/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.test;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;

public class ServerWSTest
extends AbstractVerticle {
    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle((Verticle)new ServerWSTest());
    }

    public void start(Promise<Void> startFuture) throws Exception {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        Router subrouter = Router.router((Vertx)this.vertx);
        router.mountSubRouter("/test", subrouter);
        SockJSHandlerOptions sockJSoptions = new SockJSHandlerOptions().setHeartbeatInterval(2000L);
        SockJSHandler handler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)sockJSoptions);
        SockJSBridgeOptions bridgeOptions = new SockJSBridgeOptions();
        bridgeOptions.addInboundPermitted(new PermittedOptions().setAddress("dummy"));
        bridgeOptions.addOutboundPermitted(new PermittedOptions().setAddress("dummy"));
        handler.bridge(bridgeOptions, event -> {
            System.out.println("Got event!");
            event.complete((Object)true);
        });
        subrouter.route("/*").handler((Handler)handler);
        HttpServerOptions options = new HttpServerOptions();
        options.setPort(4444);
        options.setCompressionSupported(true);
        options.setLogActivity(true);
        HttpServer server = this.vertx.createHttpServer(options);
        server.requestHandler((Handler)router);
        server.listen(rh -> {
            if (rh.failed()) {
                startFuture.fail(rh.cause());
            } else {
                try {
                    startFuture.complete();
                    HttpClientOptions clientOptions = new HttpClientOptions();
                    clientOptions.setDefaultPort(4444).setDefaultHost("localhost");
                    HttpClient client = this.vertx.createHttpClient(clientOptions);
                    client.webSocket("/test/websocket", wsHandler -> {
                        WebSocket ws = (WebSocket)wsHandler.result();
                        System.out.println("WS Connected");
                        JsonObject msg = new JsonObject().put("type", (Object)"register").put("address", (Object)"dummy");
                        ws.writeFinalTextFrame(msg.encode());
                        ws.handler(buff -> {
                            String str = buff.toString();
                            System.out.println("Got event on client: " + str);
                        });
                    });
                    this.vertx.setPeriodic(1000L, rh2 -> {
                        System.out.println("Sending message");
                        this.vertx.eventBus().publish("dummy", (Object)"hello world");
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    startFuture.fail((Throwable)e);
                }
            }
        });
    }
}

