/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search.transformer;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.search.index.node.NodeContainerTransformer;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class NodeContainerTransformerTest
extends AbstractMeshTest {
    @Test
    public void testNodeTagFamilyTransformer() {
        try (Tx tx = this.tx();){
            NodeContainerTransformer transformer = new NodeContainerTransformer(this.options(), tx.roleDao());
            ContentDao contentDao = tx.contentDao();
            HibBranch branch = this.project().getLatestBranch();
            HibNodeFieldContainer node = contentDao.getFieldContainer(this.content("concorde"), this.english(), branch, ContainerType.PUBLISHED);
            JsonObject document = transformer.toDocument(node, branch.getUuid(), ContainerType.PUBLISHED);
            JsonObject families = document.getJsonObject("tagFamilies");
            HashSet<String> basicNames = new HashSet<String>(Arrays.asList("Plane", "Twinjet"));
            HashSet<String> colorNames = new HashSet<String>(Arrays.asList("red"));
            JsonArray basicArray = families.getJsonObject("basic").getJsonArray("tags");
            JsonArray colorArray = families.getJsonObject("colors").getJsonArray("tags");
            Assert.assertEquals((String)"Incorrect count of basic tags", (long)basicNames.size(), (long)basicArray.size());
            Assert.assertEquals((String)"Incorrect count of colors", (long)colorNames.size(), (long)colorArray.size());
            boolean allTagsContained = basicArray.stream().map(obj -> ((JsonObject)obj).getString("name")).allMatch(name -> basicNames.contains(name));
            boolean allColorsContained = colorArray.stream().map(obj -> ((JsonObject)obj).getString("name")).allMatch(name -> colorNames.contains(name));
            Assert.assertTrue((String)"Could not find all basic tags", (boolean)allTagsContained);
            Assert.assertTrue((String)"Could not find all colors", (boolean)allColorsContained);
            JsonArray roleUuids = document.getJsonArray("_roleUuids");
            Assert.assertEquals((String)"The role information was not correctly set", (long)2L, (long)roleUuids.size());
        }
    }
}

