/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test;

import com.gentics.mesh.core.rest.error.Errors;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import io.vertx.core.Vertx;
import io.vertx.reactivex.core.file.FileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class RxTest {
    @Test
    public void testMultipleSingles1() throws InterruptedException {
        ArrayList<Single<String>> list = new ArrayList<Single<String>>();
        for (int i = 0; i < 10; ++i) {
            list.add(this.createSingle(i));
        }
        long start = System.currentTimeMillis();
        List finalList = (List)Observable.fromIterable(list).concatMapEager(s -> s.toObservable()).toList().blockingGet();
        for (String value : finalList) {
            System.out.println(value);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Duration: " + duration);
    }

    private Single<String> createSingle(int i) {
        return Single.create(sub -> new Thread(() -> {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sub.onSuccess((Object)("test_" + i));
        }).start());
    }

    @Test
    public void testScheduler() throws IOException {
        long start = System.currentTimeMillis();
        Observable waitForA = this.constructWaitFor();
        Observable waitForB = this.constructWaitFor();
        waitForA = waitForA.subscribeOn(Schedulers.newThread());
        waitForB = waitForB.subscribeOn(Schedulers.newThread());
        Observable waitFor = Observable.merge((ObservableSource)waitForA, (ObservableSource)waitForB);
        System.out.println("------------");
        waitFor.subscribe();
        waitFor.subscribe();
        long duration = System.currentTimeMillis() - start;
        System.out.println("Execution took: " + duration);
    }

    @Test
    public void testRXFs() {
        io.vertx.reactivex.core.Vertx rxVertx = io.vertx.reactivex.core.Vertx.newInstance((Vertx)Vertx.vertx());
        FileSystem fileSystem = rxVertx.fileSystem();
        fileSystem.rxExists("/tmp").doOnError(error -> {
            System.out.println("err\u00f6r");
            throw Errors.error((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_upload_failed", (Throwable)error);
        }).flatMap(e -> {
            System.out.println("blar");
            return Single.just((Object)false);
        }).subscribe();
    }

    private Observable<String> constructWaitFor() {
        return Observable.just((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five", (Object)"six", (Object)"seven", (Object)"eight", (Object)"nine", (Object)"ten").map(text -> {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Done waiting: " + text);
            return text;
        });
    }
}

