/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.cli.BootstrapInitializer;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.NodeMigrationActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PermissionRoots;
import com.gentics.mesh.core.data.dao.ProjectDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.demo.UserInfo;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.json.MeshJsonException;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.mockito.Mockito;

public class TestDataProvider {
    private static final Logger log = LoggerFactory.getLogger(TestDataProvider.class);
    public static final String PROJECT_NAME = "dummy";
    public static final String INITIAL_BRANCH_NAME = "dummy";
    public static final String TAG_CATEGORIES_SCHEMA_NAME = "tagCategories";
    public static final String TAG_DEFAULT_SCHEMA_NAME = "tag";
    public static final String CONTENT_UUID = "43ee8f9ff71e4016ae8f9ff71e10161c";
    public static final String NEWS_UUID = "4b1346a2163a4ff89346a2163a9ff883";
    private static TestDataProvider instance;
    private Database db;
    private BootstrapInitializer boot;
    private String english = "en";
    private String german = "de";
    private HibProject project;
    private String projectUuid;
    private String branchUuid;
    private UserInfo userInfo;
    private TestSize size;
    private Map<String, HibSchema> schemaContainers = new HashMap<String, HibSchema>();
    private Map<String, HibMicroschema> microschemaContainers = new HashMap<String, HibMicroschema>();
    private Map<String, HibTagFamily> tagFamilies = new HashMap<String, HibTagFamily>();
    private long contentCount = 0L;
    private Map<String, HibNode> folders = new HashMap<String, HibNode>();
    private Map<String, HibNode> contents = new HashMap<String, HibNode>();
    private Map<String, HibTag> tags = new HashMap<String, HibTag>();
    private Map<String, HibUser> users = new HashMap<String, HibUser>();
    private Map<String, HibRole> roles = new HashMap<String, HibRole>();
    private Map<String, HibGroup> groups = new HashMap<String, HibGroup>();
    private String contentUuid;
    private Provider<EventQueueBatch> queueProvider;

    public static TestDataProvider getInstance() {
        return instance;
    }

    public TestDataProvider(TestSize size, BootstrapInitializer boot, Database database, Provider<EventQueueBatch> queueProvider) {
        this.size = size;
        this.boot = boot;
        this.db = database;
        this.queueProvider = queueProvider;
        instance = this;
    }

    public void setup(MeshOptions meshOptions, boolean setAdminPassword) throws JsonParseException, JsonMappingException, IOException, MeshSchemaException {
        long start = System.currentTimeMillis();
        if (this.getSize() == TestSize.EMPTY) {
            return;
        }
        this.db.tx(tx -> {
            this.boot.globalCacheClear();
            if (meshOptions.getInitialAdminPassword() != null && !meshOptions.getInitialAdminPassword().startsWith("debug")) {
                meshOptions.setInitialAdminPassword(null);
            }
            this.boot.initMandatoryData(meshOptions);
            this.boot.initBasicData(meshOptions);
            if (setAdminPassword) {
                this.setAdminPassword(tx);
            }
            this.boot.initOptionalData(true);
            this.schemaContainers.clear();
            this.microschemaContainers.clear();
            this.tagFamilies.clear();
            this.contents.clear();
            this.folders.clear();
            this.tags.clear();
            this.users.clear();
            this.roles.clear();
            this.groups.clear();
            this.addBootstrappedData(tx);
            this.addSchemaContainers();
            this.addUserGroupRoleProject(tx);
            if (this.getSize() == TestSize.FULL) {
                this.addMicroschemaContainers();
                this.addTagFamilies();
                this.addTags();
            }
            this.addFolderStructure(tx);
            if (this.getSize() == TestSize.FULL) {
                this.addContents(tx);
            }
            long startPerm = System.currentTimeMillis();
            this.addPermissions(this.tagFamilies.values());
            this.addPermissions(this.roles.values());
            this.addPermissions(this.groups.values());
            this.addPermissions(this.users.values());
            this.addPermissions(this.folders.values());
            this.addPermissions(this.contents.values());
            this.addPermissions(this.tags.values());
            this.addPermissions(this.schemaContainers.values());
            this.addPermissions(this.microschemaContainers.values());
            this.addPermissions((HibBaseElement)this.project);
            this.addPermissions((HibBaseElement)this.project.getBaseNode());
            this.addPermissions(this.project.getBranchPermissionRoot());
            this.addPermissions((HibBaseElement)this.project.getInitialBranch());
            this.addPermissions(this.project.getTagFamilyPermissionRoot());
            PermissionRoots permissionRoots = tx.data().permissionRoots();
            this.addPermissions(permissionRoots.project());
            this.addPermissions(permissionRoots.user());
            this.addPermissions(permissionRoots.group());
            this.addPermissions(permissionRoots.role());
            this.addPermissions(permissionRoots.microschema());
            this.addPermissions(permissionRoots.schema());
            log.debug((Object)("Added BasicPermissions to nodes took {" + (System.currentTimeMillis() - startPerm) + "} ms."));
            tx.success();
        });
        long duration = System.currentTimeMillis() - start;
        log.debug((Object)("Setup took: {" + duration + "}"));
    }

    private void setAdminPassword(Tx tx) {
        String hash = "$2a$10$X7NA0kiqrFlyX0NUhPdW1e7jevHyoaoB4OyoxV1pdA7B3SLVSkx22";
        UserDao userDao = tx.userDao();
        userDao.updatePasswordHash(userDao.findByUsername("admin"), hash);
    }

    private void addPermissions(HibBaseElement element) {
        this.addPermissions(Arrays.asList(element));
    }

    public TestSize getSize() {
        return this.size;
    }

    private void addPermissions(Collection<? extends HibBaseElement> elements) {
        RoleDao roleDao = Tx.get().roleDao();
        HibRole role = this.userInfo.getRole();
        for (HibBaseElement hibBaseElement : elements) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Granting CRUD permissions on {" + hibBaseElement.getId() + "} with role {" + role.getId() + "}"));
            }
            roleDao.grantPermissions(role, hibBaseElement, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.CREATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.UPDATE_PERM, InternalPermission.READ_PUBLISHED_PERM, InternalPermission.PUBLISH_PERM});
        }
    }

    private void addBootstrappedData(Tx tx) {
        for (HibGroup group : tx.groupDao().findAll()) {
            this.groups.put(group.getName(), group);
        }
        for (HibUser user : tx.userDao().findAll()) {
            this.users.put(user.getUsername(), user);
        }
        for (HibRole role : tx.roleDao().findAll()) {
            this.roles.put(role.getName(), role);
        }
    }

    private void addContents(Tx tx) {
        TagDao tagDao = tx.tagDao();
        this.addContent(tx, this.folders.get("2014"), "News_2014", "News!", "Neuigkeiten!");
        this.addContent(tx, this.folders.get("march"), "New_in_March_2014", "This is new in march 2014.", "Das ist neu im M\u00e4rz 2014");
        HibNode content = this.addContent(tx, this.folders.get("news"), "News Overview", "News Overview", "News \u00dcbersicht", CONTENT_UUID);
        this.contentUuid = content.getUuid();
        this.addContent(tx, this.folders.get("deals"), "Super Special Deal 2015", "Buy two get nine!", "Kauf zwei und nimm neun mit!");
        this.addContent(tx, this.folders.get("deals"), "Special Deal June 2015", "Buy two get three!", "Kauf zwei und nimm drei mit!");
        this.addContent(tx, this.folders.get("2015"), "Special News_2014", "News!", "Neuigkeiten!");
        this.addContent(tx, this.folders.get("2015"), "News_2015", "News!", "Neuigkeiten!");
        HibNode concorde = this.addContent(tx, this.folders.get("products"), "Concorde", "A\u00e9rospatiale-BAC Concorde is a turbojet-powered supersonic passenger jet airliner that was in service from 1976 to 2003.", "Die A\u00e9rospatiale-BAC Concorde 101/102, kurz Concorde (franz\u00f6sisch und englisch f\u00fcr Eintracht, Einigkeit), ist ein \u00dcberschall-Passagierflugzeug, das von 1976 bis 2003 betrieben wurde.");
        tagDao.addTag(concorde, this.tags.get("plane"), this.project.getLatestBranch());
        tagDao.addTag(concorde, this.tags.get("twinjet"), this.project.getLatestBranch());
        tagDao.addTag(concorde, this.tags.get("red"), this.project.getLatestBranch());
        HibNode hondaNR = this.addContent(tx, this.folders.get("products"), "Honda NR", "The Honda NR (New Racing) was a V-four motorcycle engine series started by Honda in 1979 with the 500cc NR500 Grand Prix racer that used oval pistons.", "Die NR750 ist ein Motorrad mit Ovalkolben-Motor des japanischen Motorradherstellers Honda, von dem in den Jahren 1991 und 1992 300 Exemplare gebaut wurden.");
        tagDao.addTag(hondaNR, this.tags.get("vehicle"), this.project.getLatestBranch());
        tagDao.addTag(hondaNR, this.tags.get("motorcycle"), this.project.getLatestBranch());
        tagDao.addTag(hondaNR, this.tags.get("green"), this.project.getLatestBranch());
    }

    private void addFolderStructure(Tx tx) {
        TagDao tagDao = tx.tagDao();
        HibNode baseNode = this.project.getBaseNode();
        HibNode news = this.addFolder(tx, baseNode, "News", "Neuigkeiten", NEWS_UUID);
        HibNode news2015 = this.addFolder(tx, news, "2015", null);
        if (this.getSize() == TestSize.FULL) {
            tagDao.addTag(news2015, this.tags.get("car"), this.project.getLatestBranch());
            tagDao.addTag(news2015, this.tags.get("bike"), this.project.getLatestBranch());
            tagDao.addTag(news2015, this.tags.get("plane"), this.project.getLatestBranch());
            tagDao.addTag(news2015, this.tags.get("jeep"), this.project.getLatestBranch());
            HibNode news2014 = this.addFolder(tx, news, "2014", null);
            this.addFolder(tx, news2014, "March", "M\u00e4rz");
            this.addFolder(tx, baseNode, "Products", "Produkte");
            this.addFolder(tx, baseNode, "Deals", "Angebote");
        }
    }

    private void addTags() {
        HibTagFamily colorTags = this.tagFamilies.get("colors");
        HibTagFamily basicTags = this.tagFamilies.get("basic");
        this.addTag("Vehicle", basicTags);
        this.addTag("Car", basicTags);
        this.addTag("Jeep", basicTags);
        this.addTag("Bike", basicTags);
        this.addTag("Motorcycle", basicTags);
        this.addTag("Bus", basicTags);
        this.addTag("Plane", basicTags);
        this.addTag("JetFigther", basicTags);
        this.addTag("Twinjet", basicTags);
        this.addTag("red", colorTags);
        this.addTag("blue", colorTags);
        this.addTag("green", colorTags);
    }

    public UserInfo createUserInfo(String username, String firstname, String lastname) {
        UserDao userDao = Tx.get().userDao();
        GroupDao groupDao = Tx.get().groupDao();
        RoleDao roleDao = Tx.get().roleDao();
        String groupName = username + "_group";
        String roleName = username + "_role";
        HibUser user = userDao.findByUsername(username);
        HibGroup group = (HibGroup)groupDao.findByName(groupName);
        HibRole role = (HibRole)roleDao.findByName(roleName);
        String password = "test123";
        if (user == null) {
            String hashedPassword = "$2a$10$n/UeWGbY9c1FHFyCqlVsY.XvNYmZ7Jjgww99SF94q/B5nomYuquom";
            log.debug((Object)("Creating user with username: " + username + " and password: " + password));
            String email = firstname.toLowerCase().substring(0, 1) + "." + lastname.toLowerCase() + "@spam.gentics.com";
            user = userDao.create(username, null);
            userDao.updatePasswordHash(user, hashedPassword);
            user.setFirstname(firstname);
            user.setLastname(lastname);
            user.setEmailAddress(email);
            user.setCreator(user);
            user.setCreationTimestamp();
            user.setEditor(user);
            user.setLastEditedTimestamp();
            this.users.put(username, user);
        }
        if (group == null) {
            group = groupDao.create(groupName, user);
            groupDao.addUser(group, user);
            group.setCreator(user);
            group.setCreationTimestamp();
            group.setEditor(user);
            group.setLastEditedTimestamp();
            this.groups.put(groupName, group);
        }
        if (role == null) {
            role = roleDao.create(roleName, user);
            groupDao.addRole(group, role);
            roleDao.grantPermissions(role, (HibBaseElement)role, new InternalPermission[]{InternalPermission.READ_PERM});
            this.roles.put(roleName, role);
        }
        return new UserInfo(user, group, role, password);
    }

    private void addUserGroupRoleProject(Tx tx) {
        UserDao userDao = tx.userDao();
        RoleDao roleDao = tx.roleDao();
        GroupDao groupDao = tx.groupDao();
        SchemaDao schemaDao = tx.schemaDao();
        ProjectDao projectDao = tx.projectDao();
        this.userInfo = this.createUserInfo("joe1", "Joe", "Doe");
        EventQueueBatch batch = (EventQueueBatch)Mockito.mock(EventQueueBatch.class);
        tx.commit();
        ((CommonTx)tx.unwrap()).data().setEventQueueBatch(batch);
        batch.dispatch();
        this.project = projectDao.create("dummy", null, null, null, this.userInfo.getUser(), (HibSchemaVersion)this.getSchemaContainer("folder").getLatestVersion(), batch);
        HibUser jobUser = this.userInfo.getUser();
        schemaDao.assign((HibFieldSchemaElement)this.getSchemaContainer("content"), this.project, jobUser, batch);
        schemaDao.assign((HibFieldSchemaElement)this.getSchemaContainer("binary_content"), this.project, jobUser, batch);
        this.projectUuid = this.project.getUuid();
        this.branchUuid = this.project.getInitialBranch().getUuid();
        if (this.getSize() == TestSize.FULL) {
            HibGroup guestGroup = groupDao.create("guests", this.userInfo.getUser());
            this.groups.put("guests", guestGroup);
            HibRole guestRole = roleDao.create("guest_role", this.userInfo.getUser());
            groupDao.addRole(guestGroup, guestRole);
            this.roles.put(guestRole.getName(), guestRole);
            HibUser user = userDao.create("guest", this.userInfo.getUser());
            userDao.addGroup(user, guestGroup);
            user.setFirstname("Guest Firstname");
            user.setLastname("Guest Lastname");
            user.setEmailAddress("guest@spam.gentics.com");
            this.users.put(user.getUsername(), user);
            HibGroup group = groupDao.create("extra_group", this.userInfo.getUser());
            this.groups.put(group.getName(), group);
            HibRole role = roleDao.create("extra_role", this.userInfo.getUser());
            this.roles.put(role.getName(), role);
        }
        NodeMigrationActionContextImpl ac = new NodeMigrationActionContextImpl();
        tx.contentDao().publish(this.project.getBaseNode(), (InternalActionContext)ac, this.getEnglish(), this.getProject().getLatestBranch(), this.getUserInfo().getUser());
        ++this.contentCount;
    }

    public void addTagFamilies() {
        TagFamilyDao tagFamilyDao = Tx.get().tagFamilyDao();
        HibTagFamily basicTagFamily = tagFamilyDao.create(this.getProject(), "basic", this.userInfo.getUser());
        basicTagFamily.setDescription("Description for basic tag family");
        this.tagFamilies.put("basic", basicTagFamily);
        HibTagFamily colorTagFamily = tagFamilyDao.create(this.getProject(), "colors", this.userInfo.getUser());
        colorTagFamily.setDescription("Description for color tag family");
        this.tagFamilies.put("colors", colorTagFamily);
    }

    private void addSchemaContainers() throws MeshSchemaException {
        this.addBootstrapSchemas();
        Tx.get().commit();
    }

    private void addBootstrapSchemas() {
        SchemaDao schemaDao = Tx.get().schemaDao();
        HibSchema folderSchemaContainer = (HibSchema)schemaDao.findByName("folder");
        this.schemaContainers.put("folder", folderSchemaContainer);
        HibSchema contentSchemaContainer = (HibSchema)schemaDao.findByName("content");
        this.schemaContainers.put("content", contentSchemaContainer);
        HibSchema binaryContentSchemaContainer = (HibSchema)schemaDao.findByName("binary_content");
        this.schemaContainers.put("binary_content", binaryContentSchemaContainer);
    }

    private void addMicroschemaContainers() throws MeshJsonException {
        this.addVCardMicroschema();
        this.addCaptionedImageMicroschema();
    }

    private void addVCardMicroschema() throws MeshJsonException {
        MicroschemaDao microschemaDao = Tx.get().microschemaDao();
        MicroschemaModelImpl vcardMicroschema = new MicroschemaModelImpl();
        vcardMicroschema.setName("vcard");
        vcardMicroschema.setDescription("Microschema for a vcard");
        StringFieldSchemaImpl firstNameFieldSchema = new StringFieldSchemaImpl();
        firstNameFieldSchema.setName("firstName");
        firstNameFieldSchema.setLabel("First Name");
        firstNameFieldSchema.setRequired(true);
        vcardMicroschema.addField((FieldSchema)firstNameFieldSchema);
        StringFieldSchemaImpl lastNameFieldSchema = new StringFieldSchemaImpl();
        lastNameFieldSchema.setName("lastName");
        lastNameFieldSchema.setLabel("Last Name");
        lastNameFieldSchema.setRequired(true);
        vcardMicroschema.addField((FieldSchema)lastNameFieldSchema);
        StringFieldSchemaImpl addressFieldSchema = new StringFieldSchemaImpl();
        addressFieldSchema.setName("address");
        addressFieldSchema.setLabel("Address");
        vcardMicroschema.addField((FieldSchema)addressFieldSchema);
        StringFieldSchemaImpl postcodeFieldSchema = new StringFieldSchemaImpl();
        postcodeFieldSchema.setName("postcode");
        postcodeFieldSchema.setLabel("Post Code");
        vcardMicroschema.addField((FieldSchema)postcodeFieldSchema);
        HibMicroschema vcardMicroschemaContainer = microschemaDao.create((MicroschemaVersionModel)vcardMicroschema, this.userInfo.getUser(), this.createBatch());
        this.microschemaContainers.put(vcardMicroschemaContainer.getName(), vcardMicroschemaContainer);
        microschemaDao.assign((HibFieldSchemaElement)vcardMicroschemaContainer, this.project, this.user(), this.createBatch());
    }

    private void addCaptionedImageMicroschema() throws MeshJsonException {
        MicroschemaDao microschemaDao = Tx.get().microschemaDao();
        MicroschemaModelImpl captionedImageMicroschema = new MicroschemaModelImpl();
        captionedImageMicroschema.setName("captionedImage");
        captionedImageMicroschema.setDescription("Microschema for a captioned image");
        NodeFieldSchemaImpl imageFieldSchema = new NodeFieldSchemaImpl();
        imageFieldSchema.setName("image");
        imageFieldSchema.setLabel("Image");
        imageFieldSchema.setAllowedSchemas(new String[]{"image"});
        captionedImageMicroschema.addField((FieldSchema)imageFieldSchema);
        StringFieldSchemaImpl captionFieldSchema = new StringFieldSchemaImpl();
        captionFieldSchema.setName("caption");
        captionFieldSchema.setLabel("Caption");
        captionedImageMicroschema.addField((FieldSchema)captionFieldSchema);
        HibMicroschema microschema = microschemaDao.create((MicroschemaVersionModel)captionedImageMicroschema, this.userInfo.getUser(), this.createBatch());
        this.microschemaContainers.put(captionedImageMicroschema.getName(), microschema);
        microschemaDao.assign((HibFieldSchemaElement)microschema, this.project, this.user(), this.createBatch());
    }

    public HibNode addFolder(Tx tx, HibNode rootNode, String englishName, String germanName) {
        return this.addFolder(tx, rootNode, englishName, germanName, null);
    }

    public HibNode addFolder(Tx tx, HibNode rootNode, String englishName, String germanName, String uuid) {
        NodeDao nodeDao = tx.nodeDao();
        ContentDao contentDao = tx.contentDao();
        NodeMigrationActionContextImpl ac = new NodeMigrationActionContextImpl();
        HibSchemaVersion schemaVersion = (HibSchemaVersion)this.schemaContainers.get("folder").getLatestVersion();
        HibBranch branch = this.project.getLatestBranch();
        HibNode folderNode = uuid == null ? nodeDao.create(rootNode, this.userInfo.getUser(), schemaVersion, this.project) : nodeDao.create(rootNode, this.userInfo.getUser(), schemaVersion, this.project, branch, uuid);
        if (germanName != null) {
            HibNodeFieldContainer germanContainer = contentDao.createFieldContainer(folderNode, this.german, branch, this.userInfo.getUser());
            germanContainer.createString("slug").setString(germanName);
            contentDao.updateDisplayFieldValue(germanContainer);
            ++this.contentCount;
            contentDao.publish(folderNode, (InternalActionContext)ac, this.getGerman(), branch, this.getUserInfo().getUser());
        }
        if (englishName != null) {
            HibNodeFieldContainer englishContainer = contentDao.createFieldContainer(folderNode, this.english, branch, this.userInfo.getUser());
            englishContainer.createString("name").setString(englishName);
            englishContainer.createString("slug").setString(englishName);
            contentDao.updateDisplayFieldValue(englishContainer);
            ++this.contentCount;
            contentDao.publish(folderNode, (InternalActionContext)ac, this.getEnglish(), branch, this.getUserInfo().getUser());
        }
        if (englishName == null || StringUtils.isEmpty((CharSequence)englishName)) {
            throw new RuntimeException("Key for folder empty");
        }
        if (this.folders.containsKey(englishName.toLowerCase())) {
            throw new RuntimeException("Collision of folders detected for key " + englishName.toLowerCase());
        }
        this.folders.put(englishName.toLowerCase(), folderNode);
        return folderNode;
    }

    public HibTag addTag(String name) {
        return this.addTag(name, this.getTagFamily("demo"));
    }

    public HibTag addTag(String name, HibTagFamily tagFamily) {
        TagDao tagDao = Tx.get().tagDao();
        if (name == null || StringUtils.isEmpty((CharSequence)name)) {
            throw new RuntimeException("Name for tag empty");
        }
        HibTag tag = tagDao.create(tagFamily, name, this.project, this.userInfo.getUser());
        this.tags.put(name.toLowerCase(), tag);
        return tag;
    }

    private HibNode addContent(Tx tx, HibNode parentNode, String name, String englishContent, String germanContent) {
        return this.addContent(tx, parentNode, name, englishContent, germanContent, null);
    }

    private HibNode addContent(Tx tx, HibNode parentNode, String name, String englishContent, String germanContent, String uuid) {
        NodeDao nodeDao = tx.nodeDao();
        ContentDao contentDao = tx.contentDao();
        NodeMigrationActionContextImpl ac = new NodeMigrationActionContextImpl();
        HibBranch branch = this.project.getLatestBranch();
        HibNode node = uuid == null ? nodeDao.create(parentNode, this.userInfo.getUser(), (HibSchemaVersion)this.schemaContainers.get("content").getLatestVersion(), this.project) : nodeDao.create(parentNode, this.userInfo.getUser(), (HibSchemaVersion)this.schemaContainers.get("content").getLatestVersion(), this.project, branch, uuid);
        if (englishContent != null) {
            HibNodeFieldContainer englishContainer = contentDao.createFieldContainer(node, this.english, branch, this.userInfo.getUser());
            englishContainer.createString("teaser").setString(name + "_english_name");
            englishContainer.createString("title").setString(name + " english title");
            englishContainer.createString("slug").setString(name + ".en.html");
            englishContainer.createHTML("content").setHtml(englishContent);
            contentDao.updateDisplayFieldValue(englishContainer);
            ++this.contentCount;
            contentDao.publish(node, (InternalActionContext)ac, this.getEnglish(), branch, this.getUserInfo().getUser());
        }
        if (germanContent != null) {
            HibNodeFieldContainer germanContainer = contentDao.createFieldContainer(node, this.german, branch, this.userInfo.getUser());
            germanContainer.createString("teaser").setString(name + " german");
            germanContainer.createString("title").setString(name + " german title");
            germanContainer.createString("slug").setString(name + ".de.html");
            germanContainer.createHTML("content").setHtml(germanContent);
            contentDao.updateDisplayFieldValue(germanContainer);
            ++this.contentCount;
            contentDao.publish(node, (InternalActionContext)ac, this.getGerman(), branch, this.getUserInfo().getUser());
        }
        if (this.contents.containsKey(name.toLowerCase())) {
            throw new RuntimeException("Collision of contents detected for key " + name.toLowerCase());
        }
        this.contents.put(name.toLowerCase(), node);
        return node;
    }

    private String getPathForNews2015Tag(Tx tx, String languageTag) {
        ContentDao contentDao = tx.contentDao();
        String name = contentDao.getLatestDraftFieldContainer(this.folders.get("news"), languageTag).getString("name").getString();
        String name2 = contentDao.getLatestDraftFieldContainer(this.folders.get("2015"), languageTag).getString("name").getString();
        return name + "/" + name2;
    }

    public String getEnglish() {
        return this.english;
    }

    public String getGerman() {
        return this.german;
    }

    public HibProject getProject() {
        Tx.maybeGet().ifPresent(tx -> {
            this.project = (HibProject)((CommonTx)tx.unwrap()).load(this.project.getId(), ((CommonTx)tx.unwrap()).projectDao().getPersistenceClass());
        });
        return this.project;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public HibNode getFolder(String name) {
        Tx.maybeGet().ifPresent(tx -> {
            HibNode folder = this.folders.get(name);
            folder = (HibNode)((CommonTx)tx.unwrap()).load(folder.getId(), ((CommonTx)tx.unwrap()).nodeDao().getPersistenceClass((HibCoreElement)folder.getProject()));
            this.folders.put(name, folder);
        });
        return this.folders.get(name);
    }

    public HibTagFamily getTagFamily(String key) {
        Tx.maybeGet().ifPresent(tx -> {
            HibTagFamily tf = this.tagFamilies.get(key);
            tf = (HibTagFamily)((CommonTx)tx.unwrap()).load(tf.getId(), ((CommonTx)tx.unwrap()).tagFamilyDao().getPersistenceClass((HibCoreElement)tf.getProject()));
            this.tagFamilies.put(key, tf);
        });
        return this.tagFamilies.get(key);
    }

    public HibNode getContent(String name) {
        Tx.maybeGet().ifPresent(tx -> {
            HibNode content = this.contents.get(name);
            content = (HibNode)((CommonTx)tx.unwrap()).load(content.getId(), ((CommonTx)tx.unwrap()).nodeDao().getPersistenceClass((HibCoreElement)content.getProject()));
            this.contents.put(name, content);
        });
        return this.contents.get(name);
    }

    public HibTag getTag(String name) {
        Tx.maybeGet().ifPresent(tx -> {
            HibTag tag = this.tags.get(name);
            tag = (HibTag)((CommonTx)tx.unwrap()).load(tag.getId(), ((CommonTx)tx.unwrap()).tagDao().getPersistenceClass());
            this.tags.put(name, tag);
        });
        return this.tags.get(name);
    }

    public HibSchema getSchemaContainer(String name) {
        Tx.maybeGet().ifPresent(tx -> {
            HibSchema schema = this.schemaContainers.get(name);
            schema = (HibSchema)((CommonTx)tx.unwrap()).load(schema.getId(), ((CommonTx)tx.unwrap()).schemaDao().getPersistenceClass());
            this.schemaContainers.put(name, schema);
        });
        return this.schemaContainers.get(name);
    }

    public HibMicroschema getMicroschemaContainer(String name) {
        Tx.maybeGet().ifPresent(tx -> {
            HibMicroschema microschema = this.microschemaContainers.get(name);
            microschema = (HibMicroschema)((CommonTx)tx.unwrap()).load(microschema.getId(), ((CommonTx)tx.unwrap()).microschemaDao().getPersistenceClass());
            this.microschemaContainers.put(name, microschema);
        });
        return this.microschemaContainers.get(name);
    }

    public Map<String, HibTag> getTags() {
        return this.tags;
    }

    public Map<String, HibNode> getContents() {
        return this.contents;
    }

    public Map<String, HibNode> getFolders() {
        return this.folders;
    }

    public Map<String, HibUser> getUsers() {
        return this.users;
    }

    public Map<String, HibGroup> getGroups() {
        return this.groups;
    }

    public Map<String, HibRole> getRoles() {
        return this.roles;
    }

    public Map<String, HibSchema> getSchemaContainers() {
        return this.schemaContainers;
    }

    public Map<String, HibMicroschema> getMicroschemaContainers() {
        return this.microschemaContainers;
    }

    public BootstrapInitializer getMeshBoot() {
        return this.boot;
    }

    public int getNodeCount() {
        return this.folders.size() + this.contents.size() + 1;
    }

    public Map<String, HibTagFamily> getTagFamilies() {
        return this.tagFamilies;
    }

    public HibRole role() {
        return this.getUserInfo().getRole();
    }

    public HibUser user() {
        return this.getUserInfo().getUser();
    }

    public HibGroup group() {
        return this.getUserInfo().getGroup();
    }

    public HibRole getAnonymousRole() {
        return this.roles.get("anonymous");
    }

    public String projectUuid() {
        return this.projectUuid;
    }

    public String getContentUuid() {
        return this.contentUuid;
    }

    public String branchUuid() {
        return this.branchUuid;
    }

    public long getContentCount() {
        return this.contentCount;
    }

    public EventQueueBatch createBatch() {
        return (EventQueueBatch)this.queueProvider.get();
    }
}

