/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.assertj;

import com.gentics.mesh.test.context.MeshTestContext;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.junit.Assert;

public class MeshTestContextAssert
extends AbstractAssert<MeshTestContextAssert, MeshTestContext> {
    public MeshTestContextAssert(MeshTestContext actual) {
        super((Object)actual, MeshTestContextAssert.class);
    }

    public MeshTestContextAssert hasUploads(long files, long folders) {
        this.hasUploadFiles(files);
        this.hasUploadFolders(folders);
        return this;
    }

    public MeshTestContextAssert hasUploadFiles(long expected) {
        String dir = ((MeshTestContext)this.actual).getOptions().getUploadOptions().getDirectory();
        this.assertCount("The upload folder did not contain the expected amount of files.", dir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]), expected);
        return this;
    }

    public MeshTestContextAssert hasUploadFolders(long expected) {
        String dir = ((MeshTestContext)this.actual).getOptions().getUploadOptions().getDirectory();
        long count = this.listFolders(dir).count();
        if (count != expected) {
            String msg = "The upload folder did not contain the expected amount of folders.";
            String info = this.listFolders(dir).map(p -> p.toAbsolutePath().toString()).collect(Collectors.joining("\n"));
            Assert.assertEquals((String)(msg + "\nFound:\n" + info + "\n\n"), (long)expected, (long)count);
        }
        return this;
    }

    public MeshTestContextAssert hasTempFiles(long expected) {
        String dir = ((MeshTestContext)this.actual).getOptions().getTempDirectory();
        this.assertCount("The tempdirectory did not contain the expected amount of files.", dir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]), expected);
        return this;
    }

    public MeshTestContextAssert hasTempUploads(long expected) {
        String dir = ((MeshTestContext)this.actual).getOptions().getUploadOptions().getTempDirectory();
        this.assertCount("The upload tempdirectory did not contain the expected amount of files.", dir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]), expected);
        return this;
    }

    private long count(String path, Predicate<? super Path> filter) {
        try {
            return Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(filter).count();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String list(String path, Predicate<? super Path> filter) {
        try {
            return Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(filter).map(p -> p.toAbsolutePath().toString()).collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> listFolders(String path) {
        try {
            return Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(p -> !p.endsWith("temp")).filter(p -> !p.equals(Paths.get(path, new String[0]))).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.toFile().listFiles(File::isDirectory).length == 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertCount(String msg, String path, Predicate<? super Path> filter, long expected) {
        long count = this.count(path, filter);
        Assert.assertEquals((String)(msg + "\nFound:\n" + this.list(path, filter) + "\n\n"), (long)expected, (long)count);
    }
}

