/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.cli.AbstractBootstrapInitializer;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.test.context.ConsistencyRule;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.PluginHelper;
import com.gentics.mesh.test.context.TestGraphHelper;
import com.gentics.mesh.test.context.TestHttpMethods;
import com.gentics.mesh.test.context.WrapperHelper;
import com.gentics.mesh.test.context.event.EventAsserter;
import com.gentics.mesh.test.docker.ElasticsearchContainer;
import com.gentics.mesh.test.util.MeshAssert;
import eu.rekawek.toxiproxy.model.ToxicList;
import io.reactivex.functions.Action;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.Timeout;

public abstract class AbstractMeshTest
implements TestHttpMethods,
TestGraphHelper,
PluginHelper,
WrapperHelper {
    private OkHttpClient httpClient;
    private EventAsserter eventAsserter;
    @Rule
    @ClassRule
    public static MeshTestContext testContext;
    @ClassRule
    public static Timeout globalTimeout;
    @Rule
    public ConsistencyRule consistency = new ConsistencyRule(this.getTestContext());

    @Override
    public MeshTestContext getTestContext() {
        return testContext;
    }

    @Before
    public void setupEventAsserter() {
        this.eventAsserter = new EventAsserter(this.getTestContext());
        testContext.waitAndClearSearchIdleEvents();
    }

    @After
    public void clearLatches() {
        this.eventAsserter().clear();
    }

    @After
    public void resetSearchVerticle() throws Exception {
        ((AbstractBootstrapInitializer)this.boot()).getCoreVerticleLoader().redeploySearchVerticle().blockingAwait();
    }

    @Override
    public OkHttpClient httpClient() {
        if (this.httpClient == null) {
            try {
                int timeout = MeshAssert.getTimeout();
                this.httpClient = new OkHttpClient.Builder().writeTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).connectTimeout((long)timeout, TimeUnit.SECONDS).build();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return this.httpClient;
    }

    public String getJson(HibNode node) throws Exception {
        InternalActionContext ac = this.mockActionContext("lang=en&version=draft");
        return (String)this.tx(tx -> ((NodeResponse)tx.nodeDao().transformToRestSync((Object)node, ac, 0, new String[0])).toJson());
    }

    protected void testPermission(InternalPermission perm, HibBaseElement element) {
        RoleDao roleDao;
        RoutingContext rc = (RoutingContext)this.tx(() -> this.mockRoutingContext());
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), element, new InternalPermission[]{perm});
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            Assert.assertTrue((String)("The role {" + this.role().getName() + "} does not grant permission on element {" + element.getUuid() + "} although we granted those permissions."), (boolean)roleDao.hasPermission(this.role(), perm, element));
            Assert.assertTrue((String)("The user has no {" + perm.getRestPerm().getName() + "} permission on node {" + element.getUuid() + "/" + element.getClass().getSimpleName() + "}"), (boolean)tx.userDao().hasPermission(this.getRequestUser(), element, perm));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), element, new InternalPermission[]{perm});
            rc.data().clear();
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            boolean hasPerm = roleDao.hasPermission(this.role(), perm, element);
            Assert.assertFalse((String)("The user's role {" + this.role().getName() + "} still got {" + perm.getRestPerm().getName() + "} permission on node {" + element.getUuid() + "/" + element.getClass().getSimpleName() + "} although we revoked it."), (boolean)hasPerm);
            hasPerm = tx.userDao().hasPermission(this.getRequestUser(), element, perm);
            Assert.assertFalse((String)("The user {" + this.getRequestUser().getUsername() + "} still got {" + perm.getRestPerm().getName() + "} permission on node {" + element.getUuid() + "/" + element.getClass().getSimpleName() + "} although we revoked it."), (boolean)hasPerm);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    protected void assertClosedFileHandleDifference(int maximumDifference, Action action) throws Exception {
        Set<String> before = this.getOpenFiles();
        action.run();
        Set<String> after = this.getOpenFiles();
        if (after.size() - before.size() > maximumDifference) {
            String info = after.stream().filter(e -> !before.contains(e)).reduce("", (a, b) -> {
                a = (String)a + "\n" + b;
                return a;
            });
            throw new RuntimeException(String.format("File handles were not closed properly: Expected max. %d additional handles, got %d Encountered the following new open files\n %s", maximumDifference, after.size() - before.size(), info));
        }
    }

    public Set<String> getOpenFiles() throws IOException {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int i = name.indexOf("@");
        if (i > 0) {
            String pid = name.substring(0, i);
            String path = "/proc/" + pid + "/fd";
            Set<String> openFiles = Files.list(Paths.get(path, new String[0])).map(this::resolvePath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            return openFiles;
        }
        throw new RuntimeException("Could not get file handle count");
    }

    private Optional<String> resolvePath(Path path) {
        try {
            return Optional.of(path.toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException e) {
            Optional<String> o = Optional.empty();
            return o;
        }
    }

    public ToxicList toxics() {
        return MeshTestContext.getProxy().toxics();
    }

    public ElasticsearchContainer elasticsearch() {
        return MeshTestContext.elasticsearchContainer();
    }

    @Override
    public EventAsserter eventAsserter() {
        return this.eventAsserter;
    }

    static {
        System.setProperty("memory.directMemory.preallocate", "false");
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        if ("jotschi".equalsIgnoreCase(System.getProperty("user.name"))) {
            System.setProperty("storage.wal.allowDirectIO", "false");
        }
        testContext = new MeshTestContext();
        globalTimeout = new Timeout(44L, TimeUnit.MINUTES);
    }
}

