/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.rest.common.ObjectPermissionGrantRequest;
import com.gentics.mesh.core.rest.common.ObjectPermissionResponse;
import com.gentics.mesh.core.rest.common.ObjectPermissionRevokeRequest;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.ClientHandler;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class AbstractRolePermissionEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadRolePermissions() {
        boolean hasPublishPermissions = (Boolean)this.tx(() -> this.getTestedElement().hasPublishPermissions());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.getRolePermissions());
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
        if (hasPublishPermissions) {
            Assertions.assertThat((List)response.getPublish()).as("Roles with publish permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
            Assertions.assertThat((List)response.getReadPublished()).as("Roles with readPublished permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
        } else {
            Assertions.assertThat((List)response.getPublish()).as("Roles with publish permission", new Object[0]).isNull();
            Assertions.assertThat((List)response.getReadPublished()).as("Roles with readPublished permission", new Object[0]).isNull();
        }
    }

    @Test
    public void testReadRolePermissionWithoutPermission() {
        this.revokeReadOnTestedElement();
        String uuid = this.getTestedUuid();
        ClientHelper.call(this.getRolePermissions(), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadRolePermissionWithoutPermissionOnRole() {
        boolean hasPublishPermissions = (Boolean)this.tx(() -> this.getTestedElement().hasPublishPermissions());
        this.revokeReadOnRole();
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.getRolePermissions());
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).isNotNull().isEmpty();
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).isNotNull().isEmpty();
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).isNotNull().isEmpty();
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).isNotNull().isEmpty();
        if (hasPublishPermissions) {
            Assertions.assertThat((List)response.getPublish()).as("Roles with publish permission", new Object[0]).isNotNull().isEmpty();
            Assertions.assertThat((List)response.getReadPublished()).as("Roles with readPublished permission", new Object[0]).isNotNull().isEmpty();
        } else {
            Assertions.assertThat((List)response.getPublish()).as("Roles with publish permission", new Object[0]).isNull();
            Assertions.assertThat((List)response.getReadPublished()).as("Roles with readPublished permission", new Object[0]).isNull();
        }
    }

    @Test
    public void testGrantRolePermissionsByUuid() {
        String anonymousUuid = (String)this.tx(() -> this.roles().get("anonymous").getUuid());
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setRead(Arrays.asList((RoleReference)new RoleReference().setUuid(anonymousUuid)));
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.grantRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous, testRole});
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testGrantRolePermissionsByName() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setUpdate(Arrays.asList((RoleReference)new RoleReference().setName("anonymous")));
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.grantRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous, testRole});
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testGrantUnknownRolePermissionsByUuid() {
        String randomUUID = UUIDUtil.randomUUID();
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setUpdate(Arrays.asList((RoleReference)new RoleReference().setUuid(randomUUID)));
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{randomUUID});
    }

    @Test
    public void testGrantUnknownRolePermissionsByName() {
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setDelete(Arrays.asList((RoleReference)new RoleReference().setName("bogus")));
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_name", (String[])new String[]{"bogus"});
    }

    @Test
    public void testGrantInvalidRolePermissions() {
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setCreate(Arrays.asList(new RoleReference()));
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"role_reference_uuid_or_name_missing", (String[])new String[0]);
    }

    @Test
    public void testGrantRolePermissionsExclusive() {
        String anonymousUuid = (String)this.tx(() -> this.roles().get("anonymous").getUuid());
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.tx(tx -> {
            HibRole adminObj = this.roles().get("admin");
            HibRole testRoleObj = this.role();
            tx.roleDao().revokePermissions(testRoleObj, (HibBaseElement)adminObj, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.roleDao().grantPermissions(adminObj, this.getTestedElement(), new InternalPermission[]{InternalPermission.UPDATE_PERM, InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
        });
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setCreate(Arrays.asList((RoleReference)new RoleReference().setUuid(anonymousUuid)));
        request.setDelete(Arrays.asList((RoleReference)new RoleReference().setUuid(anonymousUuid)));
        request.setExclusive(true);
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.grantRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous});
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous});
        Set adminPermissions = (Set)this.tx(tx -> tx.roleDao().getPermissions(this.roles().get("admin"), this.getTestedElement()));
        Assertions.assertThat((Iterable)adminPermissions).as("Permissions for role admin", new Object[0]).isNotNull().containsOnly((Object[])new InternalPermission[]{InternalPermission.UPDATE_PERM, InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
    }

    @Test
    public void testGrantRolePermissionsExclusiveWithIgnore() {
        String anonymousUuid = (String)this.tx(() -> this.roles().get("anonymous").getUuid());
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.tx(tx -> {
            HibRole adminObj = this.roles().get("admin");
            HibRole testRoleObj = this.role();
            tx.roleDao().revokePermissions(testRoleObj, (HibBaseElement)adminObj, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.roleDao().grantPermissions(adminObj, this.getTestedElement(), new InternalPermission[]{InternalPermission.UPDATE_PERM, InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
        });
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setCreate(Arrays.asList((RoleReference)new RoleReference().setUuid(anonymousUuid)));
        request.setDelete(Arrays.asList((RoleReference)new RoleReference().setUuid(anonymousUuid)));
        request.setExclusive(true);
        request.setIgnore(Arrays.asList(testRole));
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.grantRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous, testRole});
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{anonymous, testRole});
        Set adminPermissions = (Set)this.tx(tx -> tx.roleDao().getPermissions(this.roles().get("admin"), this.getTestedElement()));
        Assertions.assertThat((Iterable)adminPermissions).as("Permissions for role admin", new Object[0]).isNotNull().containsOnly((Object[])new InternalPermission[]{InternalPermission.UPDATE_PERM, InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
    }

    @Test
    public void testGrantRoleWithoutPermission() {
        String uuid = this.getTestedUuid();
        this.revokeReadOnTestedElement();
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testGrantRoleWithoutReadPermissionOnRole() {
        String testRoleUuid = (String)this.tx(() -> this.role().getUuid());
        RoleReference testRoleRef = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.revokeReadOnRole();
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setCreate(Arrays.asList(testRoleRef));
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{testRoleUuid});
    }

    @Test
    public void testGrantRoleWithoutUpdatePermissionOnRole() {
        String testRoleUuid = (String)this.tx(() -> this.role().getUuid());
        RoleReference testRoleRef = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.revokeUpdateOnRole();
        ObjectPermissionGrantRequest request = new ObjectPermissionGrantRequest();
        request.setCreate(Arrays.asList(testRoleRef));
        ClientHelper.call(this.grantRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{testRoleUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testRevokeRolePermissionsByUuid() {
        String testRoleUuid = (String)this.tx(() -> this.role().getUuid());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setCreate(Arrays.asList((RoleReference)new RoleReference().setUuid(testRoleUuid)));
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.revokeRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getCreate()).as("Roles with create permission", new Object[0]).isNotNull().isEmpty();
        Assertions.assertThat((List)response.getRead()).as("Roles with read permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testRevokeRolePermissionsByName() {
        String testRoleName = (String)this.tx(() -> this.role().getName());
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setUpdate(Arrays.asList((RoleReference)new RoleReference().setName(testRoleName)));
        ObjectPermissionResponse response = (ObjectPermissionResponse)ClientHelper.call(this.revokeRolePermissions(request));
        ((AbstractObjectAssert)Assertions.assertThat((Object)response).as("Response", new Object[0])).isNotNull();
        Assertions.assertThat((List)response.getUpdate()).as("Roles with update permission", new Object[0]).isNotNull().isEmpty();
        Assertions.assertThat((List)response.getDelete()).as("Roles with delete permission", new Object[0]).isNotNull().containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testRevokeUnknownRolePermissionsByUuid() {
        String randomUUID = UUIDUtil.randomUUID();
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setUpdate(Arrays.asList((RoleReference)new RoleReference().setUuid(randomUUID)));
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{randomUUID});
    }

    @Test
    public void testRevoketUnknownRolePermissionsByName() {
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setDelete(Arrays.asList((RoleReference)new RoleReference().setName("bogus")));
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_name", (String[])new String[]{"bogus"});
    }

    @Test
    public void testRevokeInvalidRolePermissions() {
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setCreate(Arrays.asList(new RoleReference()));
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"role_reference_uuid_or_name_missing", (String[])new String[0]);
    }

    @Test
    public void testRevokeRoleWithoutPermission() {
        String uuid = this.getTestedUuid();
        this.revokeReadOnTestedElement();
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testRevokeRoleWithoutReadPermissionOnRole() {
        String testRoleUuid = (String)this.tx(() -> this.role().getUuid());
        RoleReference testRoleRef = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.revokeReadOnRole();
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setCreate(Arrays.asList(testRoleRef));
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{testRoleUuid});
    }

    @Test
    public void testRevokeRoleWithoutUpdatePermissionOnRole() {
        String testRoleUuid = (String)this.tx(() -> this.role().getUuid());
        RoleReference testRoleRef = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        this.revokeUpdateOnRole();
        ObjectPermissionRevokeRequest request = new ObjectPermissionRevokeRequest();
        request.setCreate(Arrays.asList(testRoleRef));
        ClientHelper.call(this.revokeRolePermissions(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{testRoleUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    protected abstract HibBaseElement getTestedElement();

    protected String getTestedUuid() {
        return (String)this.tx(() -> this.getTestedElement().getUuid());
    }

    protected void revokeReadOnTestedElement() {
        this.tx(tx -> tx.roleDao().revokePermissions(this.role(), this.getTestedElement(), new InternalPermission[]{InternalPermission.READ_PERM}));
    }

    protected void revokeReadOnRole() {
        this.tx(tx -> tx.roleDao().revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.READ_PERM}));
    }

    protected void revokeUpdateOnRole() {
        this.tx(tx -> tx.roleDao().revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM}));
    }

    protected abstract ClientHandler<ObjectPermissionResponse> getRolePermissions();

    protected abstract ClientHandler<ObjectPermissionResponse> grantRolePermissions(ObjectPermissionGrantRequest var1);

    protected abstract ClientHandler<ObjectPermissionResponse> revokeRolePermissions(ObjectPermissionRevokeRequest var1);
}

