/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.endpoint.admin.consistency.ConsistencyCheck;
import com.gentics.mesh.core.endpoint.admin.consistency.ConsistencyCheckResult;
import com.gentics.mesh.core.rest.admin.consistency.ConsistencyCheckResponse;
import com.gentics.mesh.dagger.MeshComponent;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ConsistencyRule
extends TestWatcher {
    private MeshTestContext testContext;

    public ConsistencyRule(MeshTestContext testContext) {
        this.testContext = testContext;
    }

    public void check() {
        MeshComponent mesh = this.testContext.getMeshComponent();
        List checks = mesh.consistencyChecks();
        try (Tx tx = mesh.database().tx();){
            ConsistencyCheckResponse response = new ConsistencyCheckResponse();
            for (ConsistencyCheck check : checks) {
                ConsistencyCheckResult result = check.invoke(mesh.database(), tx, false);
                response.getInconsistencies().addAll(result.getResults());
            }
            Assertions.assertThat((List)response.getInconsistencies()).as("Inconsistencies", new Object[0]).isEmpty();
        }
    }

    protected void succeeded(Description description) {
        Class testClass = description.getTestClass();
        if (testClass != null && testClass.isAnnotationPresent(NoConsistencyCheck.class)) {
            return;
        }
        if (description.getAnnotation(NoConsistencyCheck.class) == null) {
            this.check();
        }
    }
}

