/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.auth.util.KeycloakUtils;
import com.gentics.mesh.cli.AbstractBootstrapInitializer;
import com.gentics.mesh.cli.MeshImpl;
import com.gentics.mesh.core.data.search.IndexHandler;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.crypto.KeyStoreHelper;
import com.gentics.mesh.dagger.MeshComponent;
import com.gentics.mesh.etc.config.AuthenticationOptions;
import com.gentics.mesh.etc.config.HttpServerConfig;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.etc.config.MonitoringConfig;
import com.gentics.mesh.etc.config.S3CacheOptions;
import com.gentics.mesh.etc.config.S3Options;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.etc.config.search.ElasticSearchOptions;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.rest.client.MeshRestClientConfig;
import com.gentics.mesh.rest.monitoring.MonitoringClientConfig;
import com.gentics.mesh.rest.monitoring.MonitoringRestClient;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.search.TrackingSearchProviderImpl;
import com.gentics.mesh.search.verticle.ElasticsearchProcessVerticle;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshInstanceProvider;
import com.gentics.mesh.test.MeshOptionChanger;
import com.gentics.mesh.test.MeshTestActions;
import com.gentics.mesh.test.MeshTestContextProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.SSLTestMode;
import com.gentics.mesh.test.TestDataProvider;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.docker.AWSContainer;
import com.gentics.mesh.test.docker.ElasticsearchContainer;
import com.gentics.mesh.test.docker.KeycloakContainer;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.test.util.TestUtils;
import com.gentics.mesh.util.UUIDUtil;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.inject.Provider;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MeshTestContext
implements TestRule {
    public static final String UNREACHABLE_HOST = "http://localhost:1";
    public static final Logger LOG;
    private static final String CONF_PATH;
    public static ElasticsearchContainer elasticsearch;
    public static KeycloakContainer keycloak;
    public static Network network;
    public static ToxiproxyContainer toxiproxy;
    public static ToxiproxyContainer.ContainerProxy proxy;
    public static OkHttpClient okHttp;
    private List<File> tmpFolders = new ArrayList<File>();
    private MeshComponent meshDagger;
    private TestDataProvider dataProvider;
    private TrackingSearchProvider trackingSearchProvider;
    private Vertx vertx;
    protected int httpPort;
    protected int httpsPort;
    protected int monitoringPort;
    private final Map<String, MeshRestClient> clients = new HashMap<String, MeshRestClient>();
    private MonitoringRestClient monitoringClient;
    private List<String> deploymentIds = new ArrayList<String>();
    private CountDownLatch idleLatch;
    private MessageConsumer<Object> idleConsumer;
    private Mesh mesh;
    private MeshTestContextProvider meshTestContextProvider;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MeshTestContext.this.starting(description);
                try {
                    base.evaluate();
                }
                finally {
                    MeshTestContext.this.finished(description);
                }
            }
        };
    }

    protected void starting(Description description) throws Throwable {
        MeshTestSetting settings = this.getSettings(description);
        if (description.isSuite()) {
            this.setupOnce(settings);
        } else {
            this.setup(settings);
        }
    }

    public void setup(MeshTestSetting settings) throws Exception {
        this.meshTestContextProvider.getInstanceProvider().initMeshData(settings, this.meshDagger);
        this.initFolders(this.mesh.getOptions());
        this.listenToSearchIdleEvent();
        switch (settings.elasticsearch()) {
            case CONTAINER_ES6: 
            case CONTAINER_ES7: {
                this.setupIndexHandlers(true);
                break;
            }
        }
        boolean setAdminPassword = settings.optionChanger() != MeshCoreOptionChanger.INITIAL_ADMIN_PASSWORD;
        this.setupData(this.mesh.getOptions(), setAdminPassword);
        switch (settings.elasticsearch()) {
            case CONTAINER_ES6: 
            case CONTAINER_ES7: {
                this.setupIndexHandlers(false);
                break;
            }
        }
        if (settings.startServer()) {
            this.setupRestEndpoints(settings);
        }
    }

    public void setupOnce(MeshTestSetting settings) throws Exception {
        this.httpPort = TestUtils.getRandomPort();
        this.httpsPort = TestUtils.getRandomPort();
        this.monitoringPort = TestUtils.getRandomPort();
        this.removeConfigDirectory();
        MeshOptions options = this.init(settings);
        try {
            this.initDagger(options, settings);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while creating dagger dependency graph", e);
        }
        this.meshDagger.boot().registerEventHandlers();
    }

    private static OkHttpClient createTestClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            int timeout = MeshAssert.getTimeout();
            builder.callTimeout(Duration.ofMinutes(timeout));
            builder.connectTimeout(Duration.ofMinutes(timeout));
            builder.writeTimeout(Duration.ofMinutes(timeout));
            builder.readTimeout(Duration.ofMinutes(timeout));
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier((hostName, sslSession) -> true);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void finished(Description description) {
        try {
            MeshTestSetting settings = this.getSettings(description);
            if (description.isSuite()) {
                this.tearDownOnce(settings);
            } else {
                this.tearDown(settings);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown(MeshTestSetting settings) throws Exception {
        this.cleanupFolders();
        if (settings.startServer()) {
            this.undeployAndReset();
            this.closeClient();
        }
        this.idleConsumer.unregister();
        switch (settings.elasticsearch()) {
            case CONTAINER_ES6: 
            case CONTAINER_ES7: 
            case CONTAINER_ES6_TOXIC: {
                this.meshDagger.searchProvider().clear().blockingAwait();
                break;
            }
            case TRACKING: {
                this.meshDagger.trackingSearchProvider().reset();
                break;
            }
        }
        this.resetDatabase(settings);
    }

    public void tearDownOnce(MeshTestSetting settings) throws Exception {
        this.mesh.shutdown();
        this.removeConfigDirectory();
        if (elasticsearch != null && elasticsearch.isRunning()) {
            elasticsearch.stop();
        }
        if (keycloak != null && keycloak.isRunning()) {
            keycloak.stop();
        }
        if (toxiproxy != null) {
            toxiproxy.stop();
            network.close();
        }
        this.meshTestContextProvider.getInstanceProvider().teardownStorage();
    }

    private void removeConfigDirectory() throws IOException {
        FileUtils.deleteDirectory((File)new File(CONF_PATH));
        System.setProperty("mesh.confDirName", CONF_PATH);
    }

    protected void setupIndexHandlers(boolean dataIndependent) throws Exception {
        for (IndexHandler handler : this.meshDagger.indexHandlerRegistry().getHandlers()) {
            if (!(dataIndependent ^ handler.isDefinitionDataDependent())) continue;
            handler.init().blockingAwait();
        }
    }

    protected MeshTestSetting getSettings(Description description) {
        Class testClass = description.getTestClass();
        if (testClass != null) {
            return testClass.getAnnotation(MeshTestSetting.class);
        }
        return (MeshTestSetting)description.getAnnotation(MeshTestSetting.class);
    }

    private void setupRestEndpoints(MeshTestSetting settings) throws Exception {
        this.mesh.getOptions().getUploadOptions().setByteLimit(Long.MAX_VALUE);
        LOG.info((Object)("Using port:  " + this.httpPort));
        this.meshDagger.routerStorageRegistry().addProject("dummy");
        this.db().tx(tx -> {
            MeshRestClientConfig.Builder httpConfigBuilder = new MeshRestClientConfig.Builder().setHost("localhost").setPort(this.httpPort).setBasePath("/api/v2").setSsl(false);
            MeshRestClient httpClient = MeshRestClient.create((MeshRestClientConfig)httpConfigBuilder.build(), (OkHttpClient)okHttp);
            httpClient.setLogin(this.getData().user().getUsername(), this.getData().getUserInfo().getPassword());
            httpClient.login().blockingGet();
            this.clients.put("http_v2", httpClient);
            SSLTestMode ssl = settings.ssl();
            MeshRestClientConfig.Builder httpsConfigBuilder = new MeshRestClientConfig.Builder().setHost("localhost").setPort(this.httpsPort).setBasePath("/api/v2").setHostnameVerification(false).setSsl(true);
            MeshRestClientConfig httpsConfig = null;
            switch (ssl) {
                case OFF: {
                    break;
                }
                case CLIENT_CERT_REQUEST: 
                case CLIENT_CERT_REQUIRED: {
                    File serverPem = MeshTestHelper.extractResource("/client-ssl/server.pem");
                    File alicePem = MeshTestHelper.extractResource("/client-ssl/alice.pem");
                    File aliceKey = MeshTestHelper.extractResource("/client-ssl/alice.key");
                    httpsConfigBuilder.addTrustedCA(serverPem.getAbsolutePath());
                    httpsConfigBuilder.setClientCert(alicePem.getAbsolutePath());
                    httpsConfigBuilder.setClientKey(aliceKey.getAbsolutePath());
                    httpsConfig = httpsConfigBuilder.build();
                    break;
                }
                case NORMAL: {
                    httpsConfig = httpsConfigBuilder.build();
                }
            }
            if (httpsConfig != null) {
                MeshRestClient httpsClient = MeshRestClient.create((MeshRestClientConfig)httpsConfig);
                httpsClient.setLogin(this.getData().user().getUsername(), this.getData().getUserInfo().getPassword());
                httpsClient.login().blockingGet();
                this.clients.put("https_v2", httpsClient);
            }
            IntStream.range(1, 2).forEach(version -> {
                MeshRestClient oldClient = MeshRestClient.create((MeshRestClientConfig)httpConfigBuilder.setBasePath("/api/v" + version).build());
                oldClient.setAuthenticationProvider(httpClient.getAuthentication());
                this.clients.put("http_v" + version, oldClient);
            });
        });
        LOG.info((Object)("Using monitoring port: " + this.monitoringPort));
        MonitoringClientConfig monitoringClientConfig = new MonitoringClientConfig.Builder().setBasePath("/api/v2").setHost("localhost").setPort(this.monitoringPort).build();
        this.monitoringClient = MonitoringRestClient.create((MonitoringClientConfig)monitoringClientConfig);
        if (this.trackingSearchProvider != null) {
            this.trackingSearchProvider.clear().blockingAwait();
        }
    }

    private Database db() {
        return this.meshDagger.database();
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    private void setupData(MeshOptions meshOptions, boolean setAdminPassword) throws Exception {
        this.meshDagger.database().setMassInsertIntent();
        this.dataProvider.setup(meshOptions, setAdminPassword);
        this.meshDagger.database().resetIntent();
    }

    private void undeployAndReset() throws Exception {
        for (String id : this.deploymentIds) {
            this.vertx.undeploy(id);
        }
    }

    private void closeClient() throws Exception {
        this.clients.values().forEach(client -> {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void resetDatabase(MeshTestSetting settings) throws Exception {
        this.meshDagger.boot().clearReferences();
        long start = System.currentTimeMillis();
        if (settings.inMemoryDB() || settings.clusterMode()) {
            if (!this.meshTestContextProvider.getInstanceProvider().fastStorageCleanup(this.meshDagger.database())) {
                this.meshDagger.database().clear();
            }
        } else {
            this.meshDagger.database().stop();
            this.meshTestContextProvider.getInstanceProvider().cleanupPhysicalStorage();
            this.meshDagger.database().setupConnectionPool();
        }
        long duration = System.currentTimeMillis() - start;
        LOG.info((Object)("Clearing DB took {" + duration + "} ms."));
        if (this.trackingSearchProvider != null) {
            this.trackingSearchProvider.reset();
        }
    }

    private void cleanupFolders() throws IOException {
        for (File folder : this.tmpFolders) {
            FileUtils.deleteDirectory((File)folder);
        }
        if (this.meshDagger != null && this.meshDagger.permissionCache() != null) {
            this.meshDagger.permissionCache().clear(false);
        }
    }

    public TestDataProvider getData() {
        return this.dataProvider;
    }

    public TrackingSearchProvider getTrackingSearchProvider() {
        return this.trackingSearchProvider;
    }

    public MeshOptions init(MeshTestSetting settings) throws Exception {
        if (settings == null) {
            throw new RuntimeException("Settings could not be found. Did you forget to add the @MeshTestSetting annotation to your test?");
        }
        this.meshTestContextProvider = MeshTestContextProvider.getProvider();
        MeshInstanceProvider meshInstanceProvider = this.meshTestContextProvider.getInstanceProvider();
        MeshOptions meshOptions = meshInstanceProvider.getOptions();
        meshOptions.getVertxOptions().setOrderedBlockingHandlers(false);
        meshOptions.getSearchOptions().setIndexCheckInterval(0L);
        if (settings.clusterMode()) {
            meshOptions.getClusterOptions().setEnabled(true);
            meshOptions.setInitCluster(true);
            meshOptions.getClusterOptions().setClusterName("cluster" + System.currentTimeMillis());
        }
        meshOptions.getMonitoringOptions().setEnabled(settings.monitoring());
        File keystoreFile = new File("target", "keystore_" + UUIDUtil.randomUUID() + ".jceks");
        keystoreFile.deleteOnExit();
        String keystorePassword = "finger";
        if (!keystoreFile.exists()) {
            KeyStoreHelper.gen((String)keystoreFile.getAbsolutePath(), (String)keystorePassword);
        }
        AuthenticationOptions authOptions = meshOptions.getAuthenticationOptions();
        authOptions.setKeystorePassword(keystorePassword);
        authOptions.setKeystorePath(keystoreFile.getAbsolutePath());
        meshOptions.setNodeName("testNode");
        this.initFolders(meshOptions);
        HttpServerConfig httpOptions = meshOptions.getHttpServerOptions();
        httpOptions.setPort(this.httpPort);
        switch (settings.ssl()) {
            case OFF: {
                httpOptions.setSsl(false);
                break;
            }
            case NORMAL: {
                File certPem = MeshTestHelper.extractResource("/ssl/cert.pem");
                File keyPem = MeshTestHelper.extractResource("/ssl/key.pem");
                httpOptions.setSsl(true);
                httpOptions.setSslPort(this.httpsPort);
                httpOptions.setCertPath(certPem.getAbsolutePath());
                httpOptions.setKeyPath(keyPem.getAbsolutePath());
                break;
            }
            case CLIENT_CERT_REQUEST: {
                File serverPem = MeshTestHelper.extractResource("/client-ssl/server.pem");
                File serverKey = MeshTestHelper.extractResource("/client-ssl/server.key");
                httpOptions.setClientAuthMode(ClientAuth.REQUEST);
                httpOptions.setSsl(true);
                httpOptions.setSslPort(this.httpsPort);
                httpOptions.setCertPath(serverPem.getAbsolutePath());
                httpOptions.setKeyPath(serverKey.getAbsolutePath());
                httpOptions.setTrustedCertPaths(Arrays.asList(serverPem.getAbsolutePath()));
                break;
            }
            case CLIENT_CERT_REQUIRED: {
                File serverPem = MeshTestHelper.extractResource("/client-ssl/server.pem");
                File serverKey = MeshTestHelper.extractResource("/client-ssl/server.key");
                httpOptions.setClientAuthMode(ClientAuth.REQUIRED);
                httpOptions.setSsl(true);
                httpOptions.setSslPort(this.httpsPort);
                httpOptions.setCertPath(serverPem.getAbsolutePath());
                httpOptions.setKeyPath(serverKey.getAbsolutePath());
                httpOptions.setTrustedCertPaths(Arrays.asList(serverPem.getAbsolutePath()));
            }
        }
        MonitoringConfig monitoringOptions = meshOptions.getMonitoringOptions();
        monitoringOptions.setPort(this.monitoringPort);
        meshInstanceProvider.initPhysicalStorage(settings);
        ElasticSearchOptions searchOptions = meshOptions.getSearchOptions();
        S3Options s3Options = meshOptions.getS3Options();
        searchOptions.setTimeout(Long.valueOf(10000L));
        String version = "6.8.1";
        switch (settings.elasticsearch()) {
            case CONTAINER_ES7: {
                searchOptions.setComplianceMode(ComplianceMode.ES_7);
                version = "7.4.0";
            }
            case CONTAINER_ES6: 
            case UNREACHABLE: {
                elasticsearch = new ElasticsearchContainer(version);
                if (!elasticsearch.isRunning()) {
                    elasticsearch.start();
                }
                elasticsearch.waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
                if (settings.elasticsearch() == ElasticsearchTestMode.UNREACHABLE) {
                    searchOptions.setUrl(UNREACHABLE_HOST);
                    break;
                }
                searchOptions.setUrl("http://" + elasticsearch.getHost() + ":" + elasticsearch.getMappedPort(9200));
                break;
            }
            case CONTAINER_ES6_TOXIC: {
                network = Network.newNetwork();
                elasticsearch = (ElasticsearchContainer)new ElasticsearchContainer(version).withNetwork(network);
                elasticsearch.waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
                toxiproxy = (ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)(System.getProperty("mesh.container.image.prefix", "") + "shopify/toxiproxy:2.1.0")).asCompatibleSubstituteFor("shopify/toxiproxy:2.1.0")).withNetwork(network);
                if (!toxiproxy.isRunning()) {
                    toxiproxy.start();
                }
                proxy = toxiproxy.getProxy((GenericContainer)elasticsearch, 9200);
                String ipAddressViaToxiproxy = proxy.getContainerIpAddress();
                int portViaToxiproxy = proxy.getProxyPort();
                if (!elasticsearch.isRunning()) {
                    elasticsearch.start();
                }
                searchOptions.setUrl("http://" + ipAddressViaToxiproxy + ":" + portViaToxiproxy);
                break;
            }
            case NONE: {
                searchOptions.setUrl(null);
                break;
            }
            case TRACKING: {
                System.setProperty("mesh.test", "true");
                break;
            }
        }
        switch (settings.awsContainer()) {
            case NONE: {
                break;
            }
            case AWS: {
                throw new IllegalStateException("AWS test container is currently unsupported");
            }
            case MINIO: {
                String ACCESS_KEY = "accessKey";
                String SECRET_KEY = "secretKey";
                AWSContainer awsContainer = new AWSContainer(new AWSContainer.CredentialsProvider(ACCESS_KEY, SECRET_KEY));
                awsContainer.start();
                s3Options.setCorsAllowedOrigins(null);
                s3Options.setCorsAllowedHeaders(null);
                s3Options.setCorsAllowedMethods(null);
                s3Options.setEnabled(true);
                s3Options.setAccessKeyId(ACCESS_KEY);
                s3Options.setBucket("test-bucket");
                S3CacheOptions s3CacheOptions = new S3CacheOptions();
                s3CacheOptions.setBucket("test-cache-bucket");
                s3Options.setS3CacheOptions(s3CacheOptions);
                s3Options.setSecretAccessKey(SECRET_KEY);
                s3Options.setRegion("eu-central-1");
                s3Options.setEndpoint("http://" + awsContainer.getHostAddress());
            }
        }
        if (settings.useKeycloak()) {
            keycloak = (KeycloakContainer)new KeycloakContainer("/keycloak/realm.json").waitingFor((WaitStrategy)Wait.forHttp((String)"/auth/realms/master-test"));
            if (!keycloak.isRunning()) {
                keycloak.start();
            }
            String realmName = "master-test";
            Set jwks = KeycloakUtils.loadJWKs((String)"http", (String)keycloak.getHost(), (int)keycloak.getMappedPort(8080), (String)realmName);
            meshOptions.getAuthenticationOptions().setPublicKeys((Collection)jwks);
        }
        settings.optionChanger().change(meshOptions);
        ((MeshOptionChanger)settings.customOptionChanger().getConstructor(new Class[0]).newInstance(new Object[0])).change(meshOptions);
        return meshOptions;
    }

    private void initFolders(MeshOptions meshOptions) throws Exception {
        String tmpDir = this.newFolder("tmpDir");
        meshOptions.setTempDirectory(tmpDir);
        String uploads = this.newFolder("testuploads");
        meshOptions.getUploadOptions().setDirectory(uploads);
        String targetUploadTmpDir = this.newFolder("uploadTmpDir");
        meshOptions.getUploadOptions().setTempDirectory(targetUploadTmpDir);
        String imageCacheDir = this.newFolder("image_cache");
        meshOptions.getImageOptions().setImageCacheDirectory(imageCacheDir);
        String plugindirPath = this.newFolder("plugins");
        meshOptions.setPluginDirectory(plugindirPath);
        this.meshTestContextProvider.getInstanceProvider().initFolders(this::newFolder);
    }

    private String newFolder(String prefix) throws IOException {
        String path = "target/" + prefix + "_" + UUIDUtil.randomUUID();
        File directory = new File(path);
        FileUtils.deleteDirectory((File)directory);
        directory.deleteOnExit();
        Assert.assertTrue((String)("Could not create dir for path {" + path + "}"), (boolean)directory.mkdirs());
        this.tmpFolders.add(directory);
        return path;
    }

    public void initDagger(MeshOptions options, MeshTestSetting settings) throws Exception {
        LOG.info((Object)"Initializing dagger context");
        try {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull MeshComponent.Builder builder = this.getMeshDaggerBuilder();
            this.mesh = new MeshImpl(options, builder);
            this.meshDagger = this.createMeshComponent(options, settings);
            this.dataProvider = new TestDataProvider(settings.testSize(), this.meshDagger.boot(), this.meshDagger.database(), (Provider<EventQueueBatch>)this.meshDagger.batchProvider());
            if (this.meshDagger.searchProvider() instanceof TrackingSearchProviderImpl) {
                this.trackingSearchProvider = this.meshDagger.trackingSearchProvider();
            }
            this.mesh.setMeshInternal((Object)this.meshDagger);
            if (!this.getOptions().getInitialAdminPassword().startsWith("debug")) {
                this.getOptions().setInitialAdminPassword(null);
            }
            this.meshDagger.boot().init(this.mesh, false, options, null);
            this.vertx = this.meshDagger.boot().vertx();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @NotNull
    protected MeshComponent.Builder getMeshDaggerBuilder() {
        return this.meshTestContextProvider.getInstanceProvider().getComponentBuilder();
    }

    public MeshComponent createMeshComponent(MeshOptions options, MeshTestSetting settings) {
        this.meshDagger = this.getMeshDaggerBuilder().configuration(options).searchProviderType(settings.elasticsearch().toSearchProviderType()).mesh(this.mesh).build();
        return this.meshDagger;
    }

    public MonitoringRestClient getMonitoringClient() {
        return this.monitoringClient;
    }

    public MeshRestClient getHttpClient() {
        return this.clients.get("http_v2");
    }

    public MeshRestClient getHttpsClient() {
        return this.clients.get("https_v2");
    }

    public MeshRestClient getHttpClient(String version) {
        return this.clients.get("http_" + version);
    }

    public static KeycloakContainer getKeycloak() {
        return keycloak;
    }

    private void listenToSearchIdleEvent() {
        this.idleConsumer = this.vertx.eventBus().consumer(MeshEvent.SEARCH_IDLE.address, handler -> {
            LOG.info((Object)"Got search idle event");
            if (this.idleLatch != null) {
                this.idleLatch.countDown();
            }
        });
    }

    public void waitAndClearSearchIdleEvents() {
        if (null == this.mesh || null == this.mesh.getOptions().getSearchOptions().getUrl() || UNREACHABLE_HOST.equals(this.mesh.getOptions().getSearchOptions().getUrl())) {
            return;
        }
        this.waitForSearchIdleEvent();
        if (this.trackingSearchProvider != null) {
            this.trackingSearchProvider.clear().blockingAwait();
        }
    }

    public void waitForSearchIdleEvent() {
        int MAX_WAIT_TIME = 30;
        Objects.requireNonNull(this.idleConsumer, "Call #listenToSearchIdleEvent first");
        ElasticsearchProcessVerticle verticle = this.getElasticSearchVerticle();
        try {
            this.idleLatch = new CountDownLatch(1);
            verticle.flush().blockingAwait();
            boolean success = this.idleLatch.await(MAX_WAIT_TIME, TimeUnit.SECONDS);
            if (!success) {
                throw new RuntimeException("Timed out after " + MAX_WAIT_TIME + " seconds waiting for search idle event.");
            }
            verticle.refresh().blockingAwait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ElasticsearchProcessVerticle getElasticSearchVerticle() {
        return ((AbstractBootstrapInitializer)this.meshDagger.boot()).getCoreVerticleLoader().getSearchVerticle();
    }

    public static ToxiproxyContainer.ContainerProxy getProxy() {
        return proxy;
    }

    public static ElasticsearchContainer elasticsearchContainer() {
        return elasticsearch;
    }

    public MeshComponent getMeshComponent() {
        return this.meshDagger;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public MeshInstanceProvider<? extends MeshOptions> getInstanceProvider() {
        return this.meshTestContextProvider.getInstanceProvider();
    }

    public MeshOptions getOptions() {
        return this.meshTestContextProvider.getOptions();
    }

    public MeshTestActions actions() {
        return this.getInstanceProvider().actions();
    }

    static {
        System.setProperty("mesh.test", "true");
        System.setProperty("memory.directMemory.preallocate", "false");
        LOG = LoggerFactory.getLogger(MeshTestContext.class);
        CONF_PATH = "target/config-" + System.currentTimeMillis();
        okHttp = MeshTestContext.createTestClient();
    }
}

