/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.core.rest.common.AbstractResponse;
import com.gentics.mesh.rest.client.MeshRequest;
import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;

public final class MeshTestHelper {
    public static CyclicBarrier prepareBarrier(int nJobs) {
        CyclicBarrier barrier = new CyclicBarrier(nJobs);
        return barrier;
    }

    public static void validateCreation(List<String> uuidList) {
        HashSet<String> uuids = new HashSet<String>();
        for (String currentUuid : uuidList) {
            Assert.assertFalse((String)"The rest api returned a response with a uuid that was returned before. Each create request must always be atomic.", (boolean)uuids.contains(currentUuid));
            uuids.add(currentUuid);
        }
    }

    public static void validateCreation(int count, Function<Integer, MeshRequest<? extends AbstractResponse>> creator) {
        List uuids = (List)Observable.range((int)0, (int)count).flatMapSingle(i -> ((MeshRequest)creator.apply((Integer)i)).toSingle()).map(AbstractResponse::getUuid).toList().blockingGet();
        MeshTestHelper.validateCreation(uuids);
    }

    public static void awaitConcurrentRequests(int count, Function<Integer, MeshRequest<?>> creator) {
        Observable.range((int)0, (int)count).flatMapCompletable(i -> ((MeshRequest)creator.apply((Integer)i)).toCompletable()).blockingAwait();
    }

    public static String getSimpleQuery(String field, String text) {
        JsonObject json = new JsonObject("{\"query\":{\"query_string\":{\"query\":\"supersonic\",\"fields\":[\"fields.content^1.0\"],\"type\":\"phrase\"}}}");
        json.getJsonObject("query").getJsonObject("query_string").put("query", (Object)text).put("fields", (Object)new JsonArray().add((Object)field)).put("type", (Object)"phrase");
        return json.encodePrettily();
    }

    public static String getUuidQuery(String uuid) {
        JsonObject json = new JsonObject("{\"query\":{\"query_string\":{\"query\":\"" + uuid + "\",\"fields\":[\"uuid^1.0\"],\"type\":\"phrase\"}}}");
        return json.encodePrettily();
    }

    public static String getSimpleTermQuery(String key, String value) {
        JsonObject request = new JsonObject("{\"query\":{\"term\":{}}}");
        request.getJsonObject("query").getJsonObject("term").put(key, (Object)new JsonObject().put("value", (Object)value).put("boost", (Object)1));
        return request.encodePrettily();
    }

    public static String getSimpleWildCardQuery(String key, String value) {
        JsonObject json = new JsonObject("{\"query\":{\"bool\":{\"must\":[{\"wildcard\":{}}]}}}");
        JsonObject wildcard = json.getJsonObject("query").getJsonObject("bool").getJsonArray("must").getJsonObject(0).getJsonObject("wildcard");
        wildcard.put(key, (Object)new JsonObject().put("wildcard", (Object)value).put("boost", (Object)1));
        return json.encodePrettily();
    }

    public static String getRangeQuery(String fieldName, double from, double to) {
        JsonObject json = new JsonObject();
        json.put("query", (Object)new JsonObject().put("range", (Object)new JsonObject().put(fieldName, (Object)new JsonObject().put("from", (Object)from).put("to", (Object)to).put("include_lower", (Object)true).put("include_upper", (Object)true).put("boost", (Object)1))));
        return json.encodePrettily();
    }

    public static File extractResource(String path) throws IOException {
        File file = new File("target", path);
        try (InputStream is = MeshTestHelper.class.getResourceAsStream(path);){
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
        }
        return file;
    }

    public static String getResourcePath(String path) throws URISyntaxException {
        URL url = MeshTestHelper.class.getResource(path);
        ((AbstractUrlAssert)Assertions.assertThat((URL)url).as("Resource URL for " + path, new Object[0])).isNotNull();
        return new File(url.toURI()).getAbsolutePath();
    }
}

