/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.MeshTestContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Set;
import org.junit.Assert;

public interface PluginHelper {
    public MeshTestContext getTestContext();

    default public void deployPlugin(Class<?> clazz, String id) {
        this.meshApi2().deployPlugin(clazz, id).blockingAwait();
    }

    default public void deployPlugin(Class<?> clazz, String id, HttpResponseStatus status, String i18nKey, String ... i18nProps) {
        try {
            this.meshApi2().deployPlugin(clazz, id).blockingAwait();
            Assert.fail((String)("Deployment of plugin {" + clazz.getSimpleName() + "/" + id + "} should have failed."));
        }
        catch (GenericRestException e) {
            ClientHelper.expectException((Throwable)e, (HttpResponseStatus)status, (String)i18nKey, (String[])i18nProps);
        }
    }

    default public String pluginDir() {
        return this.getTestContext().getOptions().getPluginDirectory();
    }

    default public Set<String> plugins() {
        return this.meshApi2().pluginIds();
    }

    default public long pluginCount() {
        return this.plugins().size();
    }

    default public Mesh meshApi2() {
        return this.getTestContext().getMesh();
    }
}

