/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.test.context.TestHelper;
import java.util.stream.Stream;
import org.mockito.Mockito;

public interface TestGraphHelper
extends TestHelper {
    default public HibProject createProject(String name, String schema) {
        EventQueueBatch batch = (EventQueueBatch)Mockito.mock(EventQueueBatch.class);
        HibSchema schemaEntity = (HibSchema)Tx.get().schemaDao().findByName(schema);
        return Tx.get().projectDao().create(name, null, null, null, this.user(), (HibSchemaVersion)schemaEntity.getLatestVersion(), batch);
    }

    default public HibBranch createBranch(String name) {
        EventQueueBatch batch = (EventQueueBatch)Mockito.mock(EventQueueBatch.class);
        HibProject project = this.project();
        return Tx.get().branchDao().create(project, name, this.user(), batch);
    }

    default public HibMicroschema createMicroschema(MicroschemaVersionModel schema) {
        EventQueueBatch batch = (EventQueueBatch)Mockito.mock(EventQueueBatch.class);
        MicroschemaDao microschemaDao = Tx.get().microschemaDao();
        return microschemaDao.create(schema, this.user(), batch);
    }

    default public HibBranch latestBranch() {
        return this.project().getLatestBranch();
    }

    default public HibBranch initialBranch() {
        return this.project().getInitialBranch();
    }

    default public Stream<HibNodeFieldContainer> getAllContents() {
        return Tx.get().nodeDao().findAll((HibCoreElement)this.project()).stream().flatMap(node -> Stream.of(ContainerType.DRAFT, ContainerType.PUBLISHED).flatMap(type -> Tx.get().contentDao().getFieldContainers(node, type).stream()));
    }
}

