/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.MeshStatus;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.impl.MeshAuthUserImpl;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.data.user.MeshAuthUser;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.FieldTypes;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.group.GroupCreateRequest;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.group.GroupUpdateRequest;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.FieldList;
import com.gentics.mesh.core.rest.node.version.NodeVersionsResponse;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.project.ProjectUpdateRequest;
import com.gentics.mesh.core.rest.role.RoleCreateRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.role.RoleUpdateRequest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.tag.TagCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyUpdateRequest;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.core.rest.tag.TagUpdateRequest;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.mock.Mocks;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.SchemaUpdateParameters;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.Rug;
import com.gentics.mesh.test.context.helper.EventHelper;
import com.gentics.mesh.util.VersionNumber;
import com.google.common.io.Resources;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public interface TestHelper
extends EventHelper,
com.gentics.mesh.test.context.helper.ClientHelper {
    default public HibRole role() {
        return this.data().role();
    }

    default public HibUser getRequestUser() {
        return this.data().getUserInfo().getUser();
    }

    default public MeshAuthUser getRequestMeshAuthUser() {
        return MeshAuthUserImpl.create((Database)this.db(), (HibUser)this.getRequestUser());
    }

    default public HibRole anonymousRole() {
        return this.data().getAnonymousRole();
    }

    default public HibGroup group() {
        return this.data().getUserInfo().getGroup();
    }

    default public String groupUuid() {
        return this.data().getUserInfo().getGroupUuid();
    }

    default public String userUuid() {
        return this.data().getUserInfo().getUserUuid();
    }

    default public String initialBranchUuid() {
        return this.data().branchUuid();
    }

    default public BranchResponse createBranchRest(String name) {
        return this.createBranchRest(name, true);
    }

    default public BranchResponse createBranchRest(String name, boolean latest) {
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(name);
        request.setLatest(latest);
        return (BranchResponse)this.client().createBranch("dummy", request, new ParameterProvider[0]).blockingGet();
    }

    default public BranchResponse getBranch() {
        return (BranchResponse)this.client().findBranchByUuid("dummy", this.initialBranchUuid(), new ParameterProvider[0]).blockingGet();
    }

    default public String roleUuid() {
        return this.data().getUserInfo().getRoleUuid();
    }

    default public String projectUuid() {
        return this.data().projectUuid();
    }

    default public String projectName() {
        return "dummy";
    }

    default public String contentUuid() {
        return this.data().getContentUuid();
    }

    default public int port() {
        return this.httpPort();
    }

    default public int httpPort() {
        return this.getTestContext().getHttpPort();
    }

    default public int httpsPort() {
        return this.getTestContext().getHttpsPort();
    }

    default public HibNode folder(String key) {
        return this.data().getFolder(key);
    }

    default public String folderUuid() {
        return (String)this.tx(() -> this.folder("news").getUuid());
    }

    default public HibNode content(String key) {
        return this.data().getContent(key);
    }

    default public Map<String, HibTagFamily> tagFamilies() {
        return this.data().getTagFamilies();
    }

    default public HibTagFamily tagFamily(String key) {
        return this.data().getTagFamily(key);
    }

    default public HibTag tag(String key) {
        return this.data().getTag(key);
    }

    default public HibSchema schemaContainer(String key) {
        return this.data().getSchemaContainer(key);
    }

    default public Map<String, HibSchema> schemaContainers() {
        return this.data().getSchemaContainers();
    }

    default public Map<String, HibRole> roles() {
        return this.data().getRoles();
    }

    default public Map<String, ? extends HibTag> tags() {
        return this.data().getTags();
    }

    default public String english() {
        return "en";
    }

    default public String german() {
        return "de";
    }

    default public Map<String, HibGroup> groups() {
        return this.data().getGroups();
    }

    default public Map<String, HibMicroschema> microschemaContainers() {
        return this.data().getMicroschemaContainers();
    }

    default public HibMicroschema microschemaContainer(String key) {
        return this.data().getMicroschemaContainers().get(key);
    }

    default public RoutingContext mockRoutingContext() {
        return Mocks.getMockedRoutingContext("", false, this.user(), this.project());
    }

    default public RoutingContext mockRoutingContext(String query) {
        return Mocks.getMockedRoutingContext(query, false, this.user(), this.project());
    }

    default public InternalActionContext mockActionContext() {
        return Mocks.getMockedInternalActionContext("", this.user(), this.project());
    }

    default public InternalActionContext mockActionContext(String query) {
        return Mocks.getMockedInternalActionContext(query, this.user(), this.project());
    }

    default public HibNode content() {
        return this.data().getContent("news overview");
    }

    default public UserResponse readUser(String uuid) {
        return (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]));
    }

    default public UserResponse updateUser(String uuid, String newUserName) {
        UserUpdateRequest userUpdateRequest = new UserUpdateRequest();
        userUpdateRequest.setUsername(newUserName);
        return (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, userUpdateRequest, new ParameterProvider[0]));
    }

    default public void deleteUser(String uuid) {
        ClientHelper.call(() -> this.client().deleteUser(uuid));
    }

    default public GroupResponse createGroup(String groupName) {
        GroupCreateRequest request = new GroupCreateRequest();
        request.setName(groupName);
        return (GroupResponse)ClientHelper.call(() -> this.client().createGroup(request));
    }

    default public GroupResponse readGroup(String uuid) {
        return (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(uuid, new ParameterProvider[0]));
    }

    default public GroupResponse updateGroup(String uuid, String newGroupName) {
        GroupUpdateRequest groupUpdateRequest = new GroupUpdateRequest();
        groupUpdateRequest.setName(newGroupName);
        return (GroupResponse)ClientHelper.call(() -> this.client().updateGroup(uuid, groupUpdateRequest));
    }

    default public void deleteGroup(String uuid) {
        ClientHelper.call(() -> this.client().deleteGroup(uuid));
    }

    default public RoleResponse createRole(String roleName) {
        RoleCreateRequest roleCreateRequest = new RoleCreateRequest();
        roleCreateRequest.setName(roleName);
        RoleResponse roleResponse = (RoleResponse)ClientHelper.call(() -> this.client().createRole(roleCreateRequest));
        return roleResponse;
    }

    default public RoleResponse createRole(String roleName, String groupUuid) {
        RoleCreateRequest roleCreateRequest = new RoleCreateRequest();
        roleCreateRequest.setName(roleName);
        RoleResponse roleResponse = (RoleResponse)ClientHelper.call(() -> this.client().createRole(roleCreateRequest));
        this.client().addRoleToGroup(groupUuid, roleResponse.getUuid()).blockingAwait();
        return roleResponse;
    }

    default public RoleResponse readRole(String uuid) {
        return (RoleResponse)ClientHelper.call(() -> this.client().findRoleByUuid(uuid, new ParameterProvider[0]));
    }

    default public void deleteRole(String uuid) {
        ClientHelper.call(() -> this.client().deleteRole(uuid));
    }

    default public RoleResponse updateRole(String uuid, String newRoleName) {
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName(newRoleName);
        return (RoleResponse)ClientHelper.call(() -> this.client().updateRole(uuid, request));
    }

    default public TagResponse createTag(String projectName, String tagFamilyUuid, String tagName) {
        TagCreateRequest tagCreateRequest = new TagCreateRequest();
        tagCreateRequest.setName(tagName);
        return (TagResponse)ClientHelper.call(() -> this.client().createTag(projectName, tagFamilyUuid, tagCreateRequest));
    }

    default public TagResponse readTag(String projectName, String tagFamilyUuid, String uuid) {
        return (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid(projectName, tagFamilyUuid, uuid, new ParameterProvider[0]));
    }

    default public TagResponse updateTag(String projectName, String tagFamilyUuid, String uuid, String newTagName) {
        TagUpdateRequest tagUpdateRequest = new TagUpdateRequest();
        tagUpdateRequest.setName(newTagName);
        return (TagResponse)ClientHelper.call(() -> this.client().updateTag(projectName, tagFamilyUuid, uuid, tagUpdateRequest));
    }

    default public MeshRequest<NodeResponse> createNodeAsync(String fieldKey, Field field) {
        String parentNodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        return this.createNodeAsync(parentNodeUuid, fieldKey, field);
    }

    default public MeshRequest<NodeResponse> createNodeAsync(String parentNodeUuid, String fieldKey, Field field) {
        this.tx(tx -> {
            this.prepareTypedSchema(this.schemaContainer("folder"), Optional.ofNullable(field).stream().map(TestHelper::fieldIntoSchema).map(schema -> schema.setName(fieldKey)).collect(Collectors.toList()), Optional.empty());
            tx.success();
        });
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNode(new NodeReference().setUuid(parentNodeUuid));
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        nodeCreateRequest.setLanguage("en");
        if (fieldKey != null) {
            nodeCreateRequest.getFields().put(fieldKey, field);
        }
        return this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})});
    }

    default public NodeResponse createNode() {
        return this.createNode("slug", (Field)new StringFieldImpl().setString(RandomStringUtils.randomAlphabetic((int)5)));
    }

    default public NodeResponse createNode(NodeResponse parent) {
        return this.createNode(parent.getUuid(), "slug", (Field)new StringFieldImpl().setString(RandomStringUtils.randomAlphabetic((int)5)));
    }

    default public NodeResponse createNode(String fieldKey, Field field) {
        String parentNodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.createNodeAsync(parentNodeUuid, fieldKey, field));
        Assert.assertNotNull((String)"The response could not be found in the result of the future.", (Object)response);
        if (fieldKey != null) {
            Assert.assertNotNull((String)"The field was not included in the response.", (Object)response.getFields().hasField(fieldKey));
        }
        return response;
    }

    default public NodeResponse createNode(String parentNodeUuid, String fieldKey, Field field) {
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.createNodeAsync(parentNodeUuid, fieldKey, field));
        Assert.assertNotNull((String)"The response could not be found in the result of the future.", (Object)response);
        if (fieldKey != null) {
            Assert.assertNotNull((String)"The field was not included in the response.", (Object)response.getFields().hasField(fieldKey));
        }
        return response;
    }

    default public int uploadImage(HibNode node, String languageTag, String fieldname, String filename, String contentType) throws IOException {
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        return this.upload(node, buffer, languageTag, fieldname, filename, contentType);
    }

    default public int upload(HibNode node, Buffer buffer, String languageTag, String fieldname, String filename, String contentType) throws IOException {
        String uuid = (String)this.tx(() -> node.getUuid());
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(node, languageTag).getVersion());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, languageTag, version.toString(), fieldname, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), filename, contentType, new ParameterProvider[0]));
        Assert.assertNotNull((Object)response);
        return buffer.length();
    }

    default public void publishNode(NodeResponse node) {
        this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]).blockingAwait();
    }

    default public void publishNodeInBranch(NodeResponse node, String branch) {
        this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch)}).blockingAwait();
    }

    default public NodeResponse readNode(String projectName, String uuid) {
        return (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(projectName, uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
    }

    default public void deleteNode(String projectName, String uuid) {
        ClientHelper.call(() -> this.client().deleteNode(projectName, uuid, new ParameterProvider[0]));
    }

    default public NodeResponse updateNode(String projectName, String uuid, String nameFieldValue) {
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNode(projectName, uuid, nodeUpdateRequest, new ParameterProvider[0]));
    }

    default public TagFamilyResponse createTagFamily(String projectName, String tagFamilyName) {
        TagFamilyCreateRequest tagFamilyCreateRequest = new TagFamilyCreateRequest();
        tagFamilyCreateRequest.setName(tagFamilyName);
        return (TagFamilyResponse)ClientHelper.call(() -> this.client().createTagFamily(projectName, tagFamilyCreateRequest));
    }

    default public TagFamilyResponse readTagFamily(String projectName, String uuid) {
        return (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid(projectName, uuid, new ParameterProvider[0]));
    }

    default public TagFamilyResponse updateTagFamily(String projectName, String uuid, String newTagFamilyName) {
        TagFamilyUpdateRequest tagFamilyUpdateRequest = new TagFamilyUpdateRequest();
        tagFamilyUpdateRequest.setName(newTagFamilyName);
        return (TagFamilyResponse)ClientHelper.call(() -> this.client().updateTagFamily(projectName, uuid, tagFamilyUpdateRequest));
    }

    default public void deleteTagFamily(String projectName, String uuid) {
        ClientHelper.call(() -> this.client().deleteTagFamily(projectName, uuid));
    }

    default public NodeResponse migrateNode(String projectName, String uuid, String sourceBranchName, String targetBranchName) {
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(projectName, uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(sourceBranchName).draft()}));
        SchemaVersionModel schema = ((HibSchemaVersion)this.schemaContainer(nodeResponse.getSchema().getName()).getLatestVersion()).getSchema();
        NodeCreateRequest create = new NodeCreateRequest();
        create.setLanguage(nodeResponse.getLanguage());
        create.setParentNode(nodeResponse.getParentNode());
        nodeResponse.getFields().keySet().forEach(arg_0 -> TestHelper.lambda$migrateNode$33(create, nodeResponse, (SchemaModel)schema, arg_0));
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode(nodeResponse.getUuid(), projectName, create, new ParameterProvider[]{new VersioningParametersImpl().setBranch(targetBranchName)}));
    }

    default public ProjectResponse createProject() {
        return this.createProject(RandomStringUtils.randomAlphabetic((int)10));
    }

    default public ProjectResponse createProject(String projectName) {
        ProjectCreateRequest projectCreateRequest = new ProjectCreateRequest();
        projectCreateRequest.setName(projectName);
        projectCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        return (ProjectResponse)ClientHelper.call(() -> this.client().createProject(projectCreateRequest));
    }

    default public ProjectResponse getProject() {
        return (ProjectResponse)this.client().findProjectByName("dummy", new ParameterProvider[0]).blockingGet();
    }

    default public ProjectResponse readProject(String uuid) {
        return (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByUuid(uuid, new ParameterProvider[0]));
    }

    default public ProjectResponse updateProject(String uuid, String projectName) {
        ProjectUpdateRequest projectUpdateRequest = new ProjectUpdateRequest();
        projectUpdateRequest.setName(projectName);
        return (ProjectResponse)ClientHelper.call(() -> this.client().updateProject(uuid, projectUpdateRequest));
    }

    default public void deleteProject(String uuid) {
        ClientHelper.call(() -> this.client().deleteProject(uuid));
    }

    default public SchemaResponse createSchema(SchemaCreateRequest request) {
        return this.createSchema("dummy", request);
    }

    default public SchemaResponse createSchema(String projectName, SchemaCreateRequest request) {
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject(projectName, schemaResponse.getUuid()).blockingAwait();
        return schemaResponse;
    }

    default public SchemaResponse createSchema(String schemaName) {
        SchemaCreateRequest schema = FieldUtil.createSchemaCreateRequest();
        schema.setName(schemaName);
        return (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]));
    }

    default public SchemaResponse getSchemaByName(String name) {
        return (SchemaResponse)((Observable)this.client().findSchemas(new ParameterProvider[0]).toSingle().to(com.gentics.mesh.test.util.TestUtils::listObservable)).filter(schema -> schema.getName().equals(name)).blockingFirst();
    }

    default public SchemaModel readSchema(String uuid) {
        return (SchemaModel)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]));
    }

    default public GenericMessageResponse updateSchema(String uuid, String schemaName, SchemaUpdateParameters ... updateParameters) {
        SchemaUpdateRequest schema = new SchemaUpdateRequest();
        schema.setName(schemaName);
        return (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(uuid, schema, (ParameterProvider[])updateParameters));
    }

    default public void updateAndMigrateSchema(SchemaResponse originalSchema, SchemaUpdateRequest request) {
        this.updateAndMigrateSchema(originalSchema.getUuid(), request);
    }

    default public void updateAndMigrateSchema(String uuid, SchemaUpdateRequest request) {
        this.waitForJob(() -> this.client().updateSchema(uuid, request, new ParameterProvider[0]).blockingAwait());
    }

    default public void deleteSchema(String uuid) {
        ClientHelper.call(() -> this.client().deleteSchema(uuid));
    }

    default public MicroschemaResponse createMicroschema(String microschemaName) {
        MicroschemaCreateRequest microschema = new MicroschemaCreateRequest();
        microschema.setName(microschemaName);
        return (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(microschema));
    }

    default public GenericMessageResponse updateMicroschema(String uuid, String microschemaName, SchemaUpdateParameters ... parameters) {
        MicroschemaUpdateRequest microschema = FieldUtil.createMinimalValidMicroschemaUpdateRequest();
        microschema.setName(microschemaName);
        return (GenericMessageResponse)ClientHelper.call(() -> this.client().updateMicroschema(uuid, microschema, (ParameterProvider[])parameters));
    }

    default public void prepareSchema(HibNode node, String mimeTypeWhitelist, String binaryFieldName) throws IOException {
        this.prepareSchema(node, mimeTypeWhitelist, binaryFieldName, null);
    }

    default public void prepareSchema(HibNode node, String mimeTypeWhitelist, String binaryFieldName, String checkServiceUrl) throws IOException {
        this.prepareTypedSchema(node, new BinaryFieldSchemaImpl().setAllowedMimeTypes(new String[]{mimeTypeWhitelist}).setCheckServiceUrl(checkServiceUrl).setName(binaryFieldName).setLabel("Binary content"), true);
    }

    default public void prepareTypedSchema(HibNode node, FieldSchema fieldSchema, boolean setAsSegmentField) throws IOException {
        this.prepareTypedSchema(node.getSchemaContainer(), List.of(fieldSchema), setAsSegmentField ? Optional.of(fieldSchema.getName()) : Optional.empty());
    }

    default public void prepareTypedSchema(HibNode node, List<FieldSchema> fieldSchemas, Optional<String> maybeSegmentFieldKey) throws IOException {
        this.prepareTypedSchema(node.getSchemaContainer(), fieldSchemas, maybeSegmentFieldKey);
    }

    default public void prepareTypedSchema(HibSchema schemaContainer, List<FieldSchema> fieldSchemas, Optional<String> maybeSegmentFieldKey) throws IOException {
        SchemaVersionModel schema = ((HibSchemaVersion)schemaContainer.getLatestVersion()).getSchema();
        fieldSchemas.stream().filter(fieldSchema -> schema.getFields().stream().filter(f -> f.getName().equals(fieldSchema.getName())).findAny().isEmpty()).forEach(fieldSchema -> {
            schema.addField(fieldSchema);
            maybeSegmentFieldKey.filter(segmentFieldKey -> segmentFieldKey.equals(fieldSchema.getName())).ifPresent(segmentFieldKey -> schema.setSegmentField(fieldSchema.getName()));
        });
        ((HibSchemaVersion)schemaContainer.getLatestVersion()).setSchema(schema);
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)schemaContainer.getLatestVersion()));
    }

    default public void prepareTypedMicroschema(HibMicroschema microschemaContainer, List<FieldSchema> fieldSchemas) throws IOException {
        MicroschemaVersionModel microschema = microschemaContainer.getLatestVersion().getSchema();
        fieldSchemas.stream().filter(fieldSchema -> microschema.getFields().stream().filter(f -> f.getName().equals(fieldSchema.getName())).findAny().isEmpty()).forEach(fieldSchema -> microschema.addField(fieldSchema));
        microschemaContainer.getLatestVersion().setSchema(microschema);
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)microschemaContainer.getLatestVersion());
    }

    default public MeshRequest<NodeResponse> uploadRandomData(HibNode node, String languageTag, String fieldKey, int binaryLen, String contentType, String fileName) {
        Buffer buffer = TestUtils.randomBuffer((int)binaryLen);
        return this.uploadData(buffer, node, languageTag, fieldKey, contentType, fileName);
    }

    default public MeshRequest<NodeResponse> uploadData(Buffer data, HibNode node, String languageTag, String fieldKey, String contentType, String fileName) {
        String uuid = (String)this.tx(() -> node.getUuid());
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(tx.nodeDao().findByUuidGlobal(uuid), "en").getVersion());
        return this.client().updateNodeBinaryField("dummy", uuid, languageTag, version.toString(), fieldKey, (InputStream)new ByteArrayInputStream(data.getBytes()), (long)data.length(), fileName, contentType, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL)});
    }

    default public File createTempFile() {
        try {
            InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
            byte[] bytes = IOUtils.toByteArray((InputStream)ins);
            Flowable obs = Flowable.just((Object)Buffer.buffer((byte[])bytes)).publish().autoConnect(2);
            File file = new File("target", "blume.jpg");
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.write((byte[])bytes, (OutputStream)fos);
                fos.flush();
            }
            return file;
        }
        catch (Exception ex) {
            return null;
        }
    }

    default public NodeResponse uploadImage(HibNode node, String languageTag, String fieldName) throws IOException {
        String contentType = "image/jpeg";
        String fileName = "blume.jpg";
        try (Tx tx = this.tx();){
            this.prepareSchema(tx.nodeDao().findByUuidGlobal(node.getUuid()), "image/.*", fieldName);
            tx.success();
        }
        String uuid = (String)this.tx(() -> node.getUuid());
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, languageTag, "draft", fieldName, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileName, contentType, new ParameterProvider[0]));
    }

    default public NodeResponse uploadImage(NodeResponse node) throws IOException {
        return this.uploadImage(node, node.getLanguage(), "binary");
    }

    default public NodeResponse uploadImage(NodeResponse node, String languageTag, String fieldName) throws IOException {
        String contentType = "image/jpeg";
        String fileName = "blume.jpg";
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), languageTag, node.getVersion(), fieldName, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileName, contentType, new ParameterProvider[0]));
    }

    default public UserResponse createUser(String username) {
        return this.createUser(username, this.groupUuid());
    }

    default public UserResponse createUser(String username, String groupUuid) {
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(username);
        request.setPassword("test1234");
        request.setGroupUuid(groupUuid);
        return (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
    }

    default public Rug createUserGroupRole(String name) {
        GroupResponse group = this.createGroup(name + "Group");
        RoleResponse role = this.createRole(name + "Role", group.getUuid());
        UserResponse user = this.createUser(name + "User", group.getUuid());
        return new Rug(user, group, role);
    }

    default public int getNodeCount() {
        return this.data().getNodeCount();
    }

    default public HttpClient createHttpClient() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost("localhost");
        options.setDefaultPort(this.port());
        HttpClient client = this.vertx().createHttpClient(options);
        return client;
    }

    default public HibSchema getSchemaContainer() {
        return this.data().getSchemaContainer("content");
    }

    default public BulkActionContext createBulkContext() {
        return (BulkActionContext)this.mesh().bulkProvider().get();
    }

    default public Map<String, HibUser> users() {
        return this.data().getUsers();
    }

    default public void disableAnonymousAccess() {
        this.meshApi().getOptions().getAuthenticationOptions().setEnableAnonymousAccess(false);
    }

    default public void assertFilesInDir(String path, long expectedCount) {
        try {
            long count = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).count();
            Assert.assertEquals((String)("The path {" + path + "} did not contain the expected amount of files."), (long)expectedCount, (long)count);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public void assertVersions(String nodeUuid, String lang, String versions, String branchName) {
        VersioningParametersImpl param = new VersioningParametersImpl();
        if (branchName != null) {
            param.setBranch(branchName);
        }
        NodeVersionsResponse response = (NodeVersionsResponse)ClientHelper.call(() -> this.client().listNodeVersions(this.projectName(), nodeUuid, new ParameterProvider[]{param}));
        Assert.assertEquals((String)"The versions did not match", (Object)versions, (Object)response.listVersions(lang));
    }

    default public void assertVersions(NodeResponse node, String versions) {
        this.assertVersions(node.getUuid(), node.getLanguage(), versions);
    }

    default public void assertVersions(String nodeUuid, String lang, String versions) {
        this.assertVersions(nodeUuid, lang, versions, null);
    }

    default public void disableAutoPurge() {
        this.mesh().boot().mesh().getOptions().getContentOptions().setAutoPurge(false);
    }

    default public MeshStatus status() {
        return this.meshApi().getStatus();
    }

    default public void status(MeshStatus status) {
        this.meshApi().setStatus(status);
    }

    default public EventQueueBatch createBatch() {
        return (EventQueueBatch)this.mesh().batchProvider().get();
    }

    default public String getESText(String name) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/elasticsearch/" + name));
    }

    default public String getText(String path) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path));
    }

    default public JsonObject getJson(String path) throws IOException {
        return new JsonObject(IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path)));
    }

    default public String getGraphQLQuery(String name) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream("/graphql/" + name);
        Objects.requireNonNull(stream, "Query {" + name + "}");
        return IOUtils.toString((InputStream)stream);
    }

    default public String getGraphQLQuery(String name, String version) throws IOException {
        InputStream stream = Optional.ofNullable(this.getClass().getResourceAsStream("/graphql/" + name + "." + version)).orElseGet(() -> this.getClass().getResourceAsStream("/graphql/" + name));
        return IOUtils.toString((InputStream)stream);
    }

    default public Buffer getBuffer(String path) throws IOException {
        InputStream ins = this.getClass().getResourceAsStream(path);
        Assert.assertNotNull((String)("The resource for path {" + path + "} could not be found"), (Object)ins);
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        return Buffer.buffer((byte[])bytes);
    }

    default public <T> T loadResourceJsonAsPojo(String path, Class<T> clazz) {
        try {
            return (T)JsonUtil.readValue((String)Resources.toString((URL)Resources.getResource((String)path), (Charset)StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public int threadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.dumpAllThreads(true, true).length;
    }

    public static FieldSchema fieldIntoSchema(Field field) {
        FieldTypes type = FieldTypes.valueByName((String)field.getType());
        switch (type) {
            case BINARY: {
                return new BinaryFieldSchemaImpl();
            }
            case BOOLEAN: {
                return new BooleanFieldSchemaImpl();
            }
            case DATE: {
                return new DateFieldSchemaImpl();
            }
            case HTML: {
                return new HtmlFieldSchemaImpl();
            }
            case MICRONODE: {
                return new MicronodeFieldSchemaImpl();
            }
            case NODE: {
                return new NodeFieldSchemaImpl();
            }
            case NUMBER: {
                return new NumberFieldSchemaImpl();
            }
            case S3BINARY: {
                return new S3BinaryFieldSchemaImpl();
            }
            case STRING: {
                return new StringFieldSchemaImpl();
            }
            case LIST: {
                FieldList fieldList = (FieldList)field;
                return new ListFieldSchemaImpl().setListType(fieldList.getItemType());
            }
        }
        throw new IllegalArgumentException("Unsupported Field type: " + field.getType());
    }

    default public String getDisplayName(HibNode node, String branchUuid) {
        HibNodeFieldContainer content = Tx.get().contentDao().findVersion(node, Arrays.asList("en"), branchUuid, "draft");
        Object displayName = content.getDisplayFieldValue();
        if (StringUtils.isEmpty((CharSequence)displayName)) {
            displayName = "unnamed node (" + node.getUuid() + ")";
        }
        return displayName;
    }

    private static /* synthetic */ void lambda$migrateNode$33(NodeCreateRequest create, NodeResponse nodeResponse, SchemaModel schema, String key) {
        create.getFields().put(key, nodeResponse.getFields().getField(key, schema.getField(key)));
    }
}

