/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context;

import com.gentics.mesh.core.data.i18n.I18NUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.context.TestHelper;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.junit.Assert;

public interface TestHttpMethods
extends TestHelper {
    public OkHttpClient httpClient();

    default public HttpUrl prepareUrl(@NotNull String path, ParameterProvider ... params) {
        HttpUrl.Builder url = new HttpUrl.Builder();
        url.scheme("http");
        url.host("localhost");
        url.port(this.port());
        url.encodedPath(path);
        if (params != null) {
            for (ParameterProvider param : params) {
                for (Map.Entry entry : param.getParameters().entrySet()) {
                    url.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        return url.build();
    }

    default public String httpGetNow(String path, ParameterProvider ... params) throws IOException {
        return this.httpGet(path, params).execute().body().string();
    }

    default public String httpGetNow(String path, String token, ParameterProvider ... params) throws IOException {
        return this.httpGet(path, token, params).execute().body().string();
    }

    default public JsonObject httpGetNowJson(String path, ParameterProvider ... params) throws IOException {
        return new JsonObject(this.httpGetNow(path, params));
    }

    default public JsonObject httpGetNowJson(String path, String token, ParameterProvider ... params) throws IOException {
        return new JsonObject(this.httpGetNow(path, token, params));
    }

    default public void assertFailure(JsonObject response, String i18nKey, String ... params) {
        String message = I18NUtil.get((Locale)Locale.ENGLISH, (String)i18nKey, (String[])params);
        Assert.assertEquals((Object)message, (Object)response.getString("message"));
    }

    default public Call httpGet(@NotNull String path, ParameterProvider ... params) {
        return this.httpGet(path, (String)null, params);
    }

    default public Call httpGet(@NotNull String path, String token, ParameterProvider ... params) {
        HttpUrl url = this.prepareUrl(path, params);
        Request.Builder b = new Request.Builder();
        b.url(url);
        b.method("GET", null);
        if (token != null) {
            b.addHeader("Cookie", "mesh.token=" + token);
        }
        return this.httpClient().newCall(b.build());
    }

    default public Call httpPost(@NotNull String path, RequestBody body, ParameterProvider ... params) {
        HttpUrl url = this.prepareUrl(path, params);
        Request.Builder b = new Request.Builder();
        b.url(url);
        b.method("POST", body);
        return this.httpClient().newCall(b.build());
    }

    default public Call httpPost(@NotNull String path, String body, ParameterProvider ... params) {
        return this.httpPost(path, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body), params);
    }

    default public Call httpPost(@NotNull String path, JsonObject json, ParameterProvider ... params) {
        return this.httpPost(path, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json.encode()), params);
    }

    default public Call httpDelete(@NotNull String path, ParameterProvider ... params) {
        HttpUrl url = this.prepareUrl(path, params);
        Request.Builder b = new Request.Builder();
        b.url(url);
        b.method("DELETE", null);
        return this.httpClient().newCall(b.build());
    }
}

