/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.event;

import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.search.verticle.eventhandler.Util;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.event.EventAsserterChain;
import com.gentics.mesh.test.context.event.EventExpectation;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EventAsserter {
    private static final Logger log = LoggerFactory.getLogger(EventAsserter.class);
    private Map<CompletableFuture<Void>, MeshEvent> futures = new HashMap<CompletableFuture<Void>, MeshEvent>();
    private Map<MeshEvent, List<JsonObject>> events = new ConcurrentHashMap<MeshEvent, List<JsonObject>>();
    private Subject<Object> eventSubject = PublishSubject.create();
    private List<EventExpectation> expectations = new ArrayList<EventExpectation>();
    private final MeshTestContext testContext;

    public EventAsserter(MeshTestContext testContext) {
        this.testContext = testContext;
    }

    public EventAsserterChain expect(MeshEvent event) {
        this.registerForEvent(event);
        return new EventAsserterChain(this, event);
    }

    public void await() {
        log.info((Object)"Waiting for events...");
        this.eventSubject.timeout(500L, TimeUnit.MILLISECONDS).onErrorResumeNext(err -> {
            if (err instanceof TimeoutException) {
                return Observable.empty();
            }
            return Observable.error((Throwable)err);
        }).ignoreElements().blockingAwait();
        log.info((Object)"Done waiting for events");
        for (EventExpectation expectation : this.expectations) {
            expectation.verify(this.events);
        }
        this.clear();
    }

    public void clear() {
        this.futures.clear();
        this.events.clear();
        this.expectations.clear();
    }

    public void registerForEvent(MeshEvent event) {
        boolean isRegistered = this.events.containsKey(event);
        if (!isRegistered) {
            CompletableFuture fut = new CompletableFuture();
            List list = this.events.computeIfAbsent(event, e -> new ArrayList());
            this.testContext.getVertx().eventBus().consumer(event.getAddress(), mh -> {
                JsonObject body = (JsonObject)mh.body();
                list.add(body);
                this.eventSubject.onNext(Util.dummyObject);
                fut.complete(null);
            });
            this.futures.put(fut, event);
        }
    }

    public void addExpectation(EventExpectation expectation) {
        this.expectations.add(expectation);
    }
}

