/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.event;

import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.MeshEventModel;
import com.gentics.mesh.test.context.event.EventAsserter;
import com.gentics.mesh.test.context.event.EventBodyExpectation;
import com.gentics.mesh.test.context.event.EventCountExpectation;
import io.reactivex.functions.Consumer;

public class EventAsserterChain {
    private EventAsserter asserter;
    private MeshEvent event;

    public EventAsserterChain(EventAsserter asserter, MeshEvent event) {
        this.asserter = asserter;
        this.event = event;
        asserter.registerForEvent(event);
    }

    public <EM extends MeshEventModel> EventAsserterChain match(int expectedCount, Class<EM> clazzOfEM, Consumer<EM> asserter) {
        this.asserter.addExpectation(new EventBodyExpectation(this.event, expectedCount, clazzOfEM, asserter));
        return this;
    }

    public EventAsserterChain total(long count) {
        this.asserter.addExpectation(new EventCountExpectation(this.event, count));
        return this;
    }

    public EventAsserterChain one() {
        return this.total(1L);
    }

    public EventAsserterChain two() {
        return this.total(2L);
    }

    public EventAsserterChain none() {
        return this.total(0L);
    }
}

