/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.event;

import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.MeshEventModel;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.context.event.EventExpectation;
import io.reactivex.functions.Consumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class EventBodyExpectation
implements EventExpectation {
    private static final Logger log = LoggerFactory.getLogger(EventBodyExpectation.class);
    private MeshEvent event;
    private int count;
    private Consumer<JsonObject> asserter;

    public <EM extends MeshEventModel> EventBodyExpectation(MeshEvent event, int count, Class<EM> clazzOfEM, Consumer<EM> tester) {
        this.event = event;
        this.count = count;
        this.asserter = e -> {
            MeshEventModel model = (MeshEventModel)JsonUtil.readValue((String)e.toString(), (Class)clazzOfEM);
            tester.accept((Object)model);
        };
    }

    @Override
    public void verify(Map<MeshEvent, List<JsonObject>> events) {
        List<JsonObject> list = events.get(this.event);
        Assert.assertNotNull((String)("No events for type {" + this.event.getAddress() + "} have been recorded."), list);
        int accepts = 0;
        Throwable lastError = null;
        for (JsonObject json : list) {
            try {
                this.asserter.accept((Object)json);
                ++accepts;
            }
            catch (Throwable t) {
                lastError = t;
            }
        }
        if (accepts == this.count) {
            return;
        }
        if (lastError != null) {
            log.info((Object)"The asserter was unable to match for the received events:");
            for (JsonObject json : list) {
                log.info((Object)json.encodePrettily());
            }
            if (lastError instanceof AssertionError) {
                throw (AssertionError)((Object)lastError);
            }
            throw new AssertionError("The body assertion for type {" + this.event.getAddress() + "} did not match for the expected amount of events. Passed: " + accepts + " of expected: " + this.count, lastError);
        }
        Assert.assertEquals((String)("The body assertion for type {" + this.event.getAddress() + "} did not match for the expected amount of events."), (long)this.count, (long)accepts);
    }
}

