/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.helper;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.cli.BootstrapInitializer;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.PersistingUserDao;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.storage.LocalBinaryStorage;
import com.gentics.mesh.core.data.storage.S3BinaryStorage;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.db.TxAction;
import com.gentics.mesh.core.db.TxAction0;
import com.gentics.mesh.core.db.TxAction1;
import com.gentics.mesh.core.db.TxAction2;
import com.gentics.mesh.dagger.MeshComponent;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.plugin.env.PluginEnvironment;
import com.gentics.mesh.plugin.manager.MeshPluginManager;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.rest.monitoring.MonitoringRestClient;
import com.gentics.mesh.search.SearchProvider;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.search.impl.ElasticSearchProvider;
import com.gentics.mesh.test.MeshTestActions;
import com.gentics.mesh.test.TestDataProvider;
import com.gentics.mesh.test.context.MeshTestContext;
import io.vertx.core.Vertx;
import java.util.function.Consumer;

public interface BaseHelper {
    public MeshTestContext getTestContext();

    default public MeshTestActions actions() {
        return this.getTestContext().actions();
    }

    default public MeshComponent mesh() {
        return this.getTestContext().getMeshComponent();
    }

    default public ElasticSearchProvider getProvider() {
        return (ElasticSearchProvider)this.searchProvider();
    }

    default public TestDataProvider data() {
        return this.getTestContext().getData();
    }

    default public HibUser user() {
        return this.data().user();
    }

    default public void grantAdmin() {
        this.modifyUser(user -> {
            user.setAdmin(true);
            Tx.get().permissionCache().clear();
        });
    }

    default public void revokeAdmin() {
        this.modifyUser(user -> {
            user.setAdmin(false);
            Tx.get().permissionCache().clear();
        });
    }

    default public HibProject project() {
        return this.data().getProject();
    }

    default public Database db() {
        return this.mesh().database();
    }

    default public Tx tx() {
        return this.db().tx();
    }

    default public void tx(TxAction0 handler) {
        this.db().tx(handler);
    }

    default public <T> T tx(TxAction1<T> handler) {
        return (T)this.db().tx(handler);
    }

    default public void tx(TxAction2 handler) {
        this.db().tx(handler);
    }

    default public <T> T tx(TxAction<T> handler) {
        return (T)this.db().tx(handler);
    }

    default public Mesh meshApi() {
        return this.boot().mesh();
    }

    default public Vertx vertx() {
        return this.getTestContext().getVertx();
    }

    default public BootstrapInitializer boot() {
        return this.mesh().boot();
    }

    default public MeshOptions options() {
        return this.mesh().options();
    }

    default public ComplianceMode complianceMode() {
        return this.options().getSearchOptions().getComplianceMode();
    }

    default public MeshPluginManager pluginManager() {
        return this.mesh().pluginManager();
    }

    default public PluginEnvironment pluginEnv() {
        return this.mesh().pluginEnv();
    }

    default public LocalBinaryStorage localBinaryStorage() {
        return this.mesh().localBinaryStorage();
    }

    default public S3BinaryStorage s3BinaryStorage() {
        return this.mesh().s3binaryStorage();
    }

    default public MeshComponent meshDagger() {
        return this.mesh();
    }

    default public SearchProvider searchProvider() {
        return this.meshDagger().searchProvider();
    }

    default public void sleep(long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    default public MonitoringRestClient monClient() {
        return this.getTestContext().getMonitoringClient();
    }

    default public MeshRestClient client() {
        return this.getTestContext().getHttpClient();
    }

    default public MeshRestClient sslClient() {
        return this.getTestContext().getHttpsClient();
    }

    default public MeshRestClient client(String version) {
        return this.getTestContext().getHttpClient(version);
    }

    default public TrackingSearchProvider trackingSearchProvider() {
        return this.getTestContext().getTrackingSearchProvider();
    }

    private void modifyUser(Consumer<HibUser> modifier) {
        Consumer<Tx> modifyAction = tx -> {
            PersistingUserDao userDao = ((CommonTx)tx.unwrap()).userDao();
            HibUser user = (HibUser)userDao.findByUuid(this.user().getUuid());
            modifier.accept(user);
            userDao.mergeIntoPersisted((HibBaseElement)user);
        };
        CommonTx tx2 = CommonTx.get();
        if (tx2 != null) {
            modifyAction.accept((Tx)tx2);
            tx2.commit();
            tx2.data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        } else {
            this.tx(modifyAction::accept);
        }
    }

    default public HibBranch reloadBranch(HibBranch branch) {
        return (HibBranch)Tx.get().branchDao().findByUuid((HibCoreElement)branch.getProject(), branch.getUuid());
    }
}

