/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.helper;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.test.context.ClientHandler;
import com.gentics.mesh.test.context.helper.EventHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import org.apache.commons.lang3.RandomStringUtils;

public interface ClientHelper
extends EventHelper {
    default public Completable migrateSchema(String schemaName) {
        return this.migrateSchema(schemaName, true);
    }

    default public Completable migrateSchema(String schemaName, boolean wait) {
        return this.findSchemaByName(schemaName).flatMapCompletable(schema -> this.client().updateSchema(schema.getUuid(), this.addRandomField((SchemaResponse)schema), new ParameterProvider[0]).toCompletable()).andThen((CompletableSource)(wait ? MeshEvent.waitForEvent((Mesh)this.meshApi(), (MeshEvent)MeshEvent.SCHEMA_MIGRATION_FINISHED) : Completable.complete()));
    }

    default public Observable<NodeResponse> findNodesBySchema(String schemaName) {
        return this.client().findNodes("dummy", new ParameterProvider[0]).toObservable().flatMap(nodes -> Observable.fromIterable((Iterable)nodes.getData())).filter(node -> node.getSchema().getName().equals(schemaName));
    }

    default public SchemaUpdateRequest addRandomField(SchemaResponse schemaResponse) {
        SchemaUpdateRequest request = schemaResponse.toUpdateRequest();
        request.getFields().add(new StringFieldSchemaImpl().setName(RandomStringUtils.randomAlphabetic((int)10)));
        return request;
    }

    default public MicroschemaUpdateRequest addRandomField(MicroschemaResponse schemaResponse) {
        MicroschemaUpdateRequest request = schemaResponse.toRequest();
        request.getFields().add(new StringFieldSchemaImpl().setName(RandomStringUtils.randomAlphabetic((int)10)));
        return request;
    }

    default public Single<SchemaResponse> findSchemaByName(String schemaName) {
        return this.fetchList(this.client().findSchemas(new ParameterProvider[0])).filter(schema -> schema.getName().equals(schemaName)).singleOrError();
    }

    default public <T> Observable<T> fetchList(MeshRequest<? extends ListResponse<T>> request) {
        return request.toObservable().flatMap(response -> Observable.fromIterable((Iterable)response.getData()));
    }

    default public HibBranch createBranch(String name, boolean latest) {
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(name);
        if (latest) {
            request.setLatest(latest);
        }
        return this.createBranch(request);
    }

    default public HibBranch createBranch(BranchCreateRequest request) {
        StringBuilder uuid = new StringBuilder();
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)com.gentics.mesh.test.ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).hasName(request.getName());
            if (request.isLatest()) {
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).isLatest();
            } else {
                ((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Created branch", new Object[0])).isNotLatest();
            }
            uuid.append(response.getUuid());
        }, JobStatus.COMPLETED, 1);
        return (HibBranch)this.tx(tx -> (HibBranch)tx.branchDao().findByUuid((HibCoreElement)this.project(), uuid.toString()));
    }

    default public NodeResponse createBinaryNode(String parentNodeUuid) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        nodeCreateRequest.setSchemaName("binary_content");
        return (NodeResponse)com.gentics.mesh.test.ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
    }

    default public Single<NodeResponse> createBinaryContent() {
        String parentUuid = ((ProjectResponse)((ProjectListResponse)this.client().findProjects(new ParameterProvider[0]).blockingGet()).getData().get(0)).getRootNode().getUuid();
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNodeUuid("uuid");
        request.setSchemaName("binary_content");
        request.setParentNodeUuid(parentUuid);
        return this.client().createNode("dummy", request, new ParameterProvider[0]).toSingle();
    }

    default public Single<NodeResponse> createBinaryContent(String uuid) {
        String parentUuid = ((ProjectResponse)((ProjectListResponse)this.client().findProjects(new ParameterProvider[0]).blockingGet()).getData().get(0)).getRootNode().getUuid();
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNodeUuid("uuid");
        request.setSchemaName("binary_content");
        request.setParentNodeUuid(parentUuid);
        return this.client().createNode(uuid, "dummy", request, new ParameterProvider[0]).toSingle();
    }

    default public <T> MeshRestClientMessageException adminCall(ClientHandler<T> handler, HttpResponseStatus status, String bodyMessageI18nKey, String ... i18nParams) {
        return this.runAsAdmin(() -> com.gentics.mesh.test.ClientHelper.call((ClientHandler)handler, (HttpResponseStatus)status, (String)bodyMessageI18nKey, (String[])i18nParams));
    }

    default public <T> T adminCall(ClientHandler<T> handler) {
        return (T)this.runAsAdmin(() -> com.gentics.mesh.test.ClientHelper.call((ClientHandler)handler));
    }

    default public <T> T nonAdminCall(ClientHandler<T> handler) {
        return (T)this.runAsNonAdmin(() -> com.gentics.mesh.test.ClientHelper.call((ClientHandler)handler));
    }
}

