/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.context.helper;

import com.gentics.elasticsearch.client.ElasticsearchClient;
import com.gentics.elasticsearch.client.HttpErrorException;
import com.gentics.mesh.Mesh;
import com.gentics.mesh.cli.AbstractBootstrapInitializer;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.AbstractResponse;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PagingParametersImpl;
import com.gentics.mesh.search.verticle.ElasticsearchProcessVerticle;
import com.gentics.mesh.search.verticle.eventhandler.SyncEventHandler;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.ClientHandler;
import com.gentics.mesh.test.context.event.EventAsserter;
import com.gentics.mesh.test.context.event.EventAsserterChain;
import com.gentics.mesh.test.context.helper.BaseHelper;
import com.gentics.mesh.test.helper.ExpectedEvent;
import com.gentics.mesh.test.helper.UnexpectedEvent;
import com.gentics.mesh.test.util.TestUtils;
import io.reactivex.Completable;
import io.reactivex.functions.Action;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.Assert;

public interface EventHelper
extends BaseHelper {
    public EventAsserter eventAsserter();

    default public void recreateIndices() throws Exception {
        SyncEventHandler.invokeClearCompletable((Mesh)this.meshApi()).blockingAwait(10L, TimeUnit.SECONDS);
        SyncEventHandler.invokeSyncCompletable((Mesh)this.meshApi()).blockingAwait(30L, TimeUnit.SECONDS);
        this.refreshIndices();
    }

    default public void waitForEvent(String address, Action code) {
        this.waitForEvent(address, code, 10000);
    }

    default public void waitForEvent(MeshEvent event, int timeoutMs) {
        this.waitForEvent(event.getAddress(), () -> {}, timeoutMs);
    }

    default public void waitForEvent(String address, Action code, int timeoutMs) {
        CountDownLatch latch = new CountDownLatch(1);
        MessageConsumer consumer = this.vertx().eventBus().consumer(address);
        consumer.handler(msg -> latch.countDown());
        consumer.completionHandler(res -> {
            if (res.failed()) {
                throw new RuntimeException("Could not listen to event", res.cause());
            }
            try {
                code.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        try {
            latch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        consumer.unregister();
    }

    default public ExpectedEvent expectEvent(MeshEvent event, int timeoutMs) {
        return this.expectEvent(event.getAddress(), () -> {}, timeoutMs);
    }

    default public ExpectedEvent expectEvent(String address, Action code, int timeoutMs) {
        return new ExpectedEvent(this.vertx(), address, code, timeoutMs);
    }

    default public UnexpectedEvent notExpectEvent(MeshEvent event, int timeoutMs) {
        return new UnexpectedEvent(this.vertx(), event.getAddress(), timeoutMs);
    }

    default public void waitForSearchIdleEvent() {
        this.getTestContext().waitForSearchIdleEvent();
    }

    default public void waitAndClearSearchIdleEvents() {
        this.getTestContext().waitAndClearSearchIdleEvents();
    }

    default public void waitForSearchIdleEvent(Completable completable) {
        this.waitForEvent(MeshEvent.SEARCH_IDLE, () -> completable.subscribe(() -> this.vertx().eventBus().publish(MeshEvent.SEARCH_FLUSH_REQUEST.address, null)));
        this.refreshIndices();
    }

    default public void waitForSearchIdleEvent(Action action) {
        this.waitForSearchIdleEvent(() -> {
            action.run();
            return null;
        });
    }

    default public <T> T waitForSearchIdleEvent(Callable<T> action) {
        try {
            AtomicReference ref = new AtomicReference();
            this.waitForEvent(MeshEvent.SEARCH_IDLE, () -> {
                ref.set(action.call());
                this.vertx().eventBus().publish(MeshEvent.SEARCH_FLUSH_REQUEST.address, null);
            });
            this.refreshIndices();
            return (T)ref.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public void waitForEvent(MeshEvent event, Action code) {
        this.waitForEvent(event.address, code);
    }

    default public void waitForEvent(MeshEvent event) {
        this.waitForEvent(event.address, () -> {});
    }

    default public void waitForPluginRegistration() {
        this.waitForEvent(MeshEvent.PLUGIN_REGISTERED, 20000);
    }

    default public JobListResponse waitForJob(Supplier<?> action) {
        return this.waitForJobs(action, JobStatus.COMPLETED, 1);
    }

    default public JobListResponse waitForJob(Runnable action) {
        return this.waitForJobs(() -> {
            action.run();
            return null;
        }, JobStatus.COMPLETED, 1);
    }

    default public <T> T runAsAdmin(Supplier<T> action) {
        boolean isAdmin = (Boolean)this.tx(() -> this.user().isAdmin());
        if (!isAdmin) {
            this.grantAdmin();
        }
        T t = action.get();
        if (!isAdmin) {
            this.revokeAdmin();
        }
        return t;
    }

    default public void runAsAdmin(Runnable action) {
        boolean isAdmin = (Boolean)this.tx(() -> this.user().isAdmin());
        if (!isAdmin) {
            this.grantAdmin();
        }
        action.run();
        if (!isAdmin) {
            this.revokeAdmin();
        }
    }

    default public <T> T runAsNonAdmin(Supplier<T> action) {
        boolean isAdmin = (Boolean)this.tx(() -> this.user().isAdmin());
        if (isAdmin) {
            this.revokeAdmin();
        }
        T t = action.get();
        if (isAdmin) {
            this.grantAdmin();
        }
        return t;
    }

    default public void runAsNonAdmin(Runnable action) {
        boolean isAdmin = (Boolean)this.tx(() -> this.user().isAdmin());
        if (isAdmin) {
            this.revokeAdmin();
        }
        action.run();
        if (isAdmin) {
            this.grantAdmin();
        }
    }

    default public JobListResponse waitForJobs(Runnable action, JobStatus status, int expectedJobs) {
        return this.waitForJobs(() -> {
            action.run();
            return null;
        }, status, expectedJobs);
    }

    default public JobListResponse waitForJobs(Supplier<?> action, JobStatus status, int expectedJobs) {
        return this.waitForJobs(action, status, expectedJobs, 30);
    }

    default public JobListResponse waitForJobs(Supplier<?> action, JobStatus status, int expectedJobs, int waitSeconds) {
        JobListResponse before = this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0])));
        Object actionResponse = action.get();
        if (actionResponse != null && actionResponse instanceof GenericMessageResponse && "Migration was not invoked. No changes were detected.".equals(((GenericMessageResponse)actionResponse).getMessage())) {
            return null;
        }
        for (int i = 0; i < waitSeconds; ++i) {
            JobListResponse response = this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0])));
            if (response.getMetainfo().getTotalCount() == before.getMetainfo().getTotalCount() + (long)expectedJobs && status != null) {
                boolean allMatching = true;
                for (JobResponse info : response.getData()) {
                    if (status.equals((Object)info.getStatus())) continue;
                    allMatching = false;
                }
                if (allMatching) {
                    return response;
                }
            }
            if (i == waitSeconds - 1) {
                String json = response == null ? "NULL" : response.toJson();
                throw new RuntimeException("Migration did not complete within " + waitSeconds + " seconds. Last job response was:\n" + json);
            }
            this.sleep(1000L);
        }
        return null;
    }

    default public void waitForLatestJob(Runnable action) {
        this.waitForLatestJob(action, JobStatus.COMPLETED);
    }

    default public void waitForLatestJob(Runnable action, JobStatus status) {
        JobListResponse before = this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0])));
        action.run();
        int MAX_WAIT = 30;
        for (int i = 0; i < 30; ++i) {
            JobResponse newJob;
            JobListResponse response = this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0])));
            List diff = TestUtils.difference((Iterable)response.getData(), (Iterable)before.getData(), AbstractResponse::getUuid);
            if (diff.size() > 1) {
                System.out.println(response.toJson());
                throw new RuntimeException("More jobs than expected");
            }
            if (diff.size() == 1 && (newJob = (JobResponse)diff.get(0)).getStatus().equals((Object)status)) {
                return;
            }
            if (i > 2) {
                System.out.println(response.toJson());
            }
            if (i == 29) {
                throw new RuntimeException("Migration did not complete within 30 seconds");
            }
            this.sleep(1000L);
        }
    }

    default public JobResponse waitForJob(Runnable action, String jobUuid, JobStatus status) {
        action.run();
        int MAX_WAIT = 120;
        for (int i = 0; i < 120; ++i) {
            JobResponse response = this.runAsAdmin(() -> (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid)));
            if (response.getStatus().equals((Object)status)) {
                return response;
            }
            if (i > 30) {
                System.out.println(response.toJson());
            }
            if (i == 119) {
                throw new RuntimeException("Job did not complete within 120 seconds");
            }
            this.sleep(1000L);
        }
        return null;
    }

    default public JobListResponse triggerAndWaitForJob(String jobUuid) {
        return this.triggerAndWaitForJob(jobUuid, JobStatus.COMPLETED);
    }

    default public JobListResponse triggerAndWaitForJob(String jobUuid, JobStatus status) {
        this.waitForJob(() -> MeshEvent.triggerJobWorker((Mesh)this.meshApi()), jobUuid, status);
        return this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0])));
    }

    default public void triggerAndWaitForAllJobs(JobStatus expectedStatus) {
        MeshEvent.triggerJobWorker((Mesh)this.meshApi());
        int MAX_WAIT = 120;
        for (int i = 0; i < 120; ++i) {
            JobListResponse response = this.runAsAdmin(() -> (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(200L))})));
            boolean allDone = true;
            for (JobResponse info : response.getData()) {
                if (info.getStatus().equals((Object)expectedStatus)) continue;
                allDone = false;
            }
            if (allDone) break;
            if (i > 30) {
                System.out.println(response.toJson());
            }
            if (i == 119) {
                throw new RuntimeException("Job did not complete within 120 seconds");
            }
            this.sleep(1000L);
        }
    }

    default public <T> T callAndWait(ClientHandler<T> handler) {
        try {
            return (T)this.waitForSearchIdleEvent(() -> handler.handle().blockingGet());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public void refreshIndices() {
        this.getSearchVerticle().refresh().blockingAwait(15L, TimeUnit.SECONDS);
    }

    default public ElasticsearchProcessVerticle getSearchVerticle() {
        return ((AbstractBootstrapInitializer)this.boot()).getCoreVerticleLoader().getSearchVerticle();
    }

    default public EventAsserterChain expect(MeshEvent event) {
        return this.eventAsserter().expect(event);
    }

    default public void awaitEvents() {
        this.eventAsserter().await();
    }

    default public void assertDocumentExists(String indexName, String documentId) {
        this.getProvider().getDocument(indexName, documentId).blockingGet();
    }

    default public void assertDocumentDoesNotExist(String indexName, String documentId) {
        try {
            this.getProvider().getDocument(indexName, documentId).blockingGet();
            Assert.fail((String)("Fetching document " + documentId + " from index " + indexName + " is expected to fail"));
        }
        catch (Exception e) {
            HttpErrorException error = (HttpErrorException)e.getCause();
            Assert.assertEquals((long)404L, (long)error.getStatusCode());
        }
    }

    default public void syncIndex() throws TimeoutException {
        try (ExpectedEvent ee = this.expectEvent(MeshEvent.INDEX_SYNC_FINISHED, 10000);){
            SyncEventHandler.invokeSync((Vertx)this.vertx(), null);
        }
        this.refreshIndices();
    }

    default public void clearIndex() throws TimeoutException {
        try (ExpectedEvent ee = this.expectEvent(MeshEvent.INDEX_CLEAR_FINISHED, 10000);){
            SyncEventHandler.invokeClear((Vertx)this.vertx());
        }
    }

    default public JsonObject getIndexMappings(String indexName) {
        ElasticsearchClient client = (ElasticsearchClient)this.searchProvider().getClient();
        return (JsonObject)client.readIndex(new String[]{indexName}).async().map(response -> response.getJsonObject(indexName).getJsonObject("mappings")).blockingGet();
    }

    default public boolean waitFor(BooleanSupplier booleanSupplier, int timeout) {
        long sleep = 100L;
        long startWait = System.currentTimeMillis();
        boolean result = false;
        while (!(result = booleanSupplier.getAsBoolean()) && System.currentTimeMillis() - startWait < (long)timeout) {
            this.sleep(sleep);
        }
        return result;
    }
}

