/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.test.definition;

import com.gentics.mesh.core.rest.SortOrder;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.parameter.SortingParameters;
import com.gentics.mesh.parameter.client.SortingParametersImpl;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;

public interface CrudEndpointTestCases {
    public void testCreate() throws Exception;

    public void testCreateReadDelete() throws Exception;

    public void testCreateWithNoPerm() throws Exception;

    public void testCreateWithUuid() throws Exception;

    @Deprecated
    public void testCreateWithDuplicateUuid() throws Exception;

    public void testReadByUUID() throws Exception;

    public void testReadByUuidWithRolePerms();

    public void testReadByUUIDWithMissingPermission() throws Exception;

    public void testReadMultiple() throws Exception;

    public void testPermissionResponse();

    public void testUpdate() throws Exception;

    public void testUpdateByUUIDWithoutPerm() throws Exception;

    public void testUpdateWithBogusUuid() throws GenericRestException, Exception;

    public void testDeleteByUUID() throws Exception;

    public void testDeleteByUUIDWithNoPermission() throws Exception;

    default public <T> void verifySorting(Function<SortingParameters, ListResponse<T>> listFunction, Function<? super T, String> extractor, String sortedAttribute, String description) {
        ListResponse<T> sortedResponse = listFunction.apply(new SortingParametersImpl().putSort(sortedAttribute, SortOrder.ASCENDING));
        List sortedData = sortedResponse.getData().stream().map(extractor).collect(Collectors.toList());
        try {
            ((AbstractListAssert)Assertions.assertThat(sortedData).as(description, new Object[0]).isNotEmpty()).isSorted();
        }
        catch (AssertionError e) {
            ((AbstractListAssert)Assertions.assertThat(sortedData).as(description, new Object[0]).isNotEmpty()).isSortedAccordingTo(String.CASE_INSENSITIVE_ORDER);
        }
        sortedResponse = listFunction.apply(new SortingParametersImpl().putSort(sortedAttribute, SortOrder.DESCENDING));
        sortedData = sortedResponse.getData().stream().map(extractor).collect(Collectors.toList());
        try {
            ((AbstractListAssert)Assertions.assertThat(sortedData).as(description, new Object[0]).isNotEmpty()).isSortedAccordingTo(Comparator.reverseOrder());
        }
        catch (AssertionError e) {
            ((AbstractListAssert)Assertions.assertThat(sortedData).as(description, new Object[0]).isNotEmpty()).isSortedAccordingTo(String.CASE_INSENSITIVE_ORDER.reversed());
        }
    }
}

