/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.util;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;

public final class CoreTestUtils {
    private CoreTestUtils() {
    }

    public static HibNodeFieldContainer createContainer() {
        return CoreTestUtils.createContainer(new FieldSchema[]{FieldUtil.createStringFieldSchema((String)"dummy")});
    }

    public static HibNodeFieldContainer createContainer(FieldSchema ... fields) {
        CommonTx ctx = CommonTx.get();
        SchemaVersionModel schema = CoreTestUtils.createSchema(fields);
        HibSchema schemaContainer = ctx.schemaDao().create(schema, null, null, false);
        HibSchemaVersion version = (HibSchemaVersion)schemaContainer.getLatestVersion();
        ctx.commit();
        return ctx.contentDao().createPersisted(UUID.randomUUID().toString(), version, null, null, new VersionNumber(), null);
    }

    public static SchemaVersionModel createSchema(FieldSchema ... fields) {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName(RandomStringUtils.random((int)10, (boolean)true, (boolean)true));
        Arrays.stream(fields).forEach(arg_0 -> CoreTestUtils.lambda$createSchema$0((SchemaVersionModel)schema, arg_0));
        return schema;
    }

    public static HibSchemaVersion createSchemaVersion(HibSchema container, String name, String version, FieldSchema ... fields) {
        HibSchemaVersion sversion = (HibSchemaVersion)CommonTx.get().schemaDao().createPersistedVersion((HibFieldSchemaElement)container, v -> CoreTestUtils.fillSchemaVersion(v, container, name, version, fields));
        Tx.get().commit();
        return sversion;
    }

    public static HibSchemaVersion fillSchemaVersion(HibSchemaVersion containerVersion, HibSchema container, String name, String versionName, FieldSchema ... fields) {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName(name);
        schema.setVersion(versionName);
        for (FieldSchema field : fields) {
            schema.addField(field);
        }
        schema.setContainer(Boolean.valueOf(false));
        schema.validate();
        containerVersion.setName(name);
        containerVersion.setSchema((SchemaVersionModel)schema);
        containerVersion.setSchemaContainer(container);
        return containerVersion;
    }

    public static HibMicroschemaVersion fillMicroschemaVersion(HibMicroschemaVersion microschemaVersion, HibMicroschema microschema, String name, String versionName, FieldSchema ... fields) {
        MicroschemaModelImpl model = new MicroschemaModelImpl();
        model.setName(name);
        model.setVersion(versionName);
        for (FieldSchema field : fields) {
            model.addField(field);
        }
        model.validate();
        microschemaVersion.setName(name);
        microschemaVersion.setSchema((MicroschemaVersionModel)model);
        microschemaVersion.setSchemaContainer(microschema);
        return microschemaVersion;
    }

    public static boolean isConflict(Throwable t) {
        return CoreTestUtils.isResponseStatus(t, HttpResponseStatus.CONFLICT);
    }

    public static boolean isResponseStatus(Throwable t, HttpResponseStatus status) {
        return CoreTestUtils.getMeshRestClientMessageException(t).map(meshException -> meshException.getStatusCode() == status.code()).orElse(false);
    }

    public static Optional<MeshRestClientMessageException> getMeshRestClientMessageException(Throwable t) {
        if (t instanceof MeshRestClientMessageException) {
            MeshRestClientMessageException meshException = (MeshRestClientMessageException)t;
            return Optional.of(meshException);
        }
        if (t.getCause() != null && t.getCause() != t) {
            return CoreTestUtils.getMeshRestClientMessageException(t.getCause());
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$createSchema$0(SchemaVersionModel schema, FieldSchema field) {
        schema.addField(field);
    }
}

