/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.example.GraphQLExamples;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.util.TestUtils;
import com.gentics.mesh.util.EncodeUtil;
import com.gentics.mesh.util.Loop;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilTest {
    @Test(expected=GenericRestException.class)
    public void testToJson() {
        JsonUtil.toJson((Object)new Loop());
    }

    @Test
    public void testJsonEncoding() throws IOException {
        this.validateEncodingHandling("UTF16BE.json", Charsets.UTF_16BE, "The\ud801\udc37 Na\ud834\udd1em\ud834\udd1ee\ud801\udc37");
        this.validateEncodingHandling("ISO8859-1.json", Charsets.ISO_8859_1, "\u00b3 for ?, \u00bf for ?");
        this.validateEncodingHandling("ISO8859-1.json", Charsets.UTF_8, "\ufffd for ?, \ufffd for ?");
    }

    public void validateEncodingHandling(String name, Charset encoding, String expected) throws IOException {
        String json = TestUtils.getJson((String)name, (Charset)encoding);
        json = EncodeUtil.ensureUtf8((String)json);
        SchemaUpdateRequest schema = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
        Assert.assertEquals((String)"The name did not match the expected value.", (Object)expected, (Object)schema.getName());
    }

    @Test
    public void testCompareJson() {
        JsonObject a = new JsonObject();
        a.put("a", (Object)"b");
        JsonObject b = new JsonObject();
        b.put("a", (Object)"b");
        Assert.assertTrue((boolean)a.equals((Object)b));
        b.put("a", (Object)"c");
        Assert.assertFalse((boolean)a.equals((Object)b));
        b.put("a", (Object)"b");
        Assert.assertTrue((boolean)a.equals((Object)b));
        a.put("another", (Object)"value");
        Assert.assertFalse((boolean)a.equals((Object)b));
    }

    @Test
    public void testJsonList() {
        ListResponse list = new ListResponse();
        UserResponse user = new UserResponse();
        list.getData().add(user);
        Assert.assertNotNull((Object)list.toJson());
    }

    @Test
    public void testGraphQLResponse() {
        GraphQLExamples examples = new GraphQLExamples();
        GraphQLResponse response = examples.createResponse();
        String jsonStr = response.toJson();
        JsonObject json = new JsonObject(jsonStr);
        System.out.println(json.encodePrettily());
        GraphQLResponse response2 = (GraphQLResponse)JsonUtil.readValue((String)jsonStr, GraphQLResponse.class);
        String username = response2.getData().getJsonObject("me").getString("username");
        Assert.assertEquals((Object)"anonymous", (Object)username);
    }

    @Test
    public void testSchema() throws JsonProcessingException {
        String json = JsonUtil.getJsonSchema(NodeResponse.class);
        Assert.assertNotNull((Object)json);
    }

    @Test
    public void testMicroschemaAllowField() {
        SchemaUpdateRequest schemaUpdate = new SchemaUpdateRequest();
        schemaUpdate.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"micro").setAllowedMicroSchemas(new String[]{"TestMicroschema"}));
        String json = schemaUpdate.toJson();
        SchemaVersionModel model = (SchemaVersionModel)JsonUtil.readValue((String)json, SchemaResponse.class);
        Assertions.assertThat((Object[])((MicronodeFieldSchemaImpl)model.getField("micro", MicronodeFieldSchemaImpl.class)).getAllowedMicroSchemas()).containsExactly((Object[])new String[]{"TestMicroschema"});
    }

    @Test
    public void testPermMap() {
        UserResponse group = new UserResponse();
        PermissionInfo info = new PermissionInfo();
        info.setOthers(false);
        info.set(Permission.READ, true);
        info.setCreate(Boolean.valueOf(true));
        group.setPermissions(info);
        Assert.assertNotNull((Object)group.toJson());
    }

    @Test
    public void testJsonFormatError() throws IOException {
        try {
            String json = "{broken}";
            JsonUtil.readValue((String)json, NodeCreateRequest.class);
            Assert.fail((String)"json parsing should fail");
        }
        catch (GenericRestException e) {
            Assert.assertEquals((Object)"error_json_malformed", (Object)e.getI18nKey());
            Assertions.assertThat((Object[])e.getI18nParameters()).containsExactly((Object[])new String[]{"1", "3", "Unexpected character ('b' (code 98)): was expecting double-quote to start field name"});
        }
    }

    @Test
    public void testJsonStructureError() throws IOException {
        try {
            String json = "{\"schema\":\"test\" }";
            JsonUtil.readValue((String)json, NodeCreateRequest.class);
            Assert.fail((String)"json parsing should fail");
        }
        catch (GenericRestException e) {
            Assert.assertEquals((Object)"error_json_structure_invalid", (Object)e.getI18nKey());
            Assertions.assertThat((Object[])e.getI18nParameters()).contains((Object[])new String[]{"1", "11", "schema"});
        }
    }

    @Test
    public void testNodeJson() throws JsonParseException, JsonMappingException, IOException {
        NodeResponse node = new NodeResponse();
        StringField stringField = FieldUtil.createStringField((String)"test");
        stringField.setString("testtext");
        FieldMapImpl fields = new FieldMapImpl();
        fields.put("test", (Field)stringField);
        node.setFields((FieldMap)fields);
        String json = node.toJson();
        Assert.assertNotNull((Object)json);
        System.out.println("From POJO: " + json);
        NodeResponse node2 = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
        Assert.assertNotNull((Object)node2);
        node2.getFields().put("extra", (Field)FieldUtil.createBooleanField((Boolean)false));
        String json2 = node2.toJson();
        System.out.println("From Deserialized POJO: " + json2);
        StringFieldImpl field = node2.getFields().getStringField("test");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"testtext", (Object)field.getString());
    }
}

