/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public final class SSLUtil {
    public static final String KEYSTORE_PASSWORD = "changeit";

    private SSLUtil() {
    }

    public static void updateKeyStore(String certPath) {
        try {
            char[] passphrase = KEYSTORE_PASSWORD.toCharArray();
            InputStream certIn = ClassLoader.class.getResourceAsStream(certPath);
            char sep = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + sep + "lib" + sep + "security");
            File file = new File(dir, "cacerts");
            FileInputStream localCertIn = new FileInputStream(file);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(localCertIn, passphrase);
            if (keystore.containsAlias("myAlias")) {
                certIn.close();
                ((InputStream)localCertIn).close();
                return;
            }
            ((InputStream)localCertIn).close();
            BufferedInputStream bis = new BufferedInputStream(certIn);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                keystore.setCertificateEntry("myAlias", cert);
            }
            certIn.close();
            FileOutputStream out = new FileOutputStream(file);
            keystore.store(out, passphrase);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

